/*
 * Rename object "oldname" to "newname".
 */

#include <Vioprotocol.h>
#include <Vnaming.h>

SystemCode Rename(oldname, newname)
  char *oldname, *newname;
  {
    MsgStruct msg;
    register NameRequest *request = (NameRequest *) &msg;
#define reply ((IoReply *) request)
    register int oldlen;
    register char *nameptr;

    request->requestcode = RENAME_FILE;
    request->nameindex = 0;
    request->unspecified[0] = oldlen = strlen(oldname);
    request->namelength = oldlen + 1 + strlen(newname);
    request->nameptr = nameptr = (char *) malloc(request->namelength + 1);

    if (nameptr == NULL) return NO_MEMORY;

    strcpy(nameptr, oldname);
    strcpy(nameptr + oldlen + 1, newname);

    NameSend(request);

    free(nameptr);

    return reply->replycode;
#undef reply
  }

/*
 * Unix emulation
 */
rename(oldname, newname)
  {
    return (Rename(oldname, newname) == OK) ? 0 : -1;
  }
