/*
 * IgnoreRetry
 *
 * Determine whether we are one of the servers that should ignore this
 *  request (probably a CREATE_INSTANCE_RETRY).  Return 1 if so, 0 if not.
 * Assumes there is a 0-terminated list of pids beginning at req->segPtr
 *  in the client's address space, and returns true if the given
 *  serverpid is on the list.
 * If an appended segment was received, segbuf and *segsize should
 *  indicate its location and size.  This routine may read in more
 *  of the segment; if so, it alters the "segsize" parameter to
 *  reflect what it read.  Assumes segbuf points to an area of at
 *  least MAX_APPENDED_SEGMENT bytes.
 */

#include <Venviron.h>

int IgnoreRetry(req, pid, segbuf, segsize, serverpid)
  register MsgStruct *req;
  ProcessId pid, serverpid;
  register char *segbuf;
  register unsigned *segsize;
  {
    register char *rsegp, *lsegp;
    register SystemCode r;
    register unsigned lsegsize, segleft;
    ProcessId checkpid;

    rsegp = req->segmentPtr;	/* remote addr of next pid to look at */
    segleft = req->segmentSize;	/* bytes not yet examined */
    lsegp = segbuf;
    lsegsize = *segsize;

    while (segleft >= sizeof(ProcessId))
      {
	if (lsegsize < sizeof(ProcessId))
	  {
	    lsegsize = (segleft < MAX_APPENDED_SEGMENT) ? 
		        segleft : MAX_APPENDED_SEGMENT;
	    r = MoveFrom(pid, segbuf, rsegp, lsegsize);
	    if (r != OK) return 1;
	    if (rsegp == req->segmentPtr)
	        *segsize = lsegsize;
	    else
	        *segsize = 0;
	  }

	if (DifferentByteOrder(pid))
	    ByteSwapLongCopy(lsegp, &checkpid, sizeof(ProcessId));
	else
	    Copy(&checkpid, lsegp, sizeof(ProcessId));

	if (checkpid == serverpid) return 1;
	if (checkpid == 0) return 0;

	rsegp += sizeof(ProcessId);
	segleft -= sizeof(ProcessId);
        lsegp += sizeof(ProcessId);
	lsegsize -= sizeof(ProcessId);
      }

    return 0;
  }
