/*
 * Function-call interface to GET_FILE_NAME message.  Gets the absolute
 * name of the file associated with the instanceid and serverpid.
 *
 * Returns a null terminated string in name.
 * namelength - size of the name buffer
 * serverpid - for the file
 * instanceid - of the file
 */

#include "Vnaming.h"

SystemCode GetFileName(name, namelength, serverpid, instanceid)
    char *name;
    unsigned namelength;
    ProcessId serverpid;
    InstanceId instanceid;
  {
    Message msg;
    register ContextRequest *request = (ContextRequest *) msg;
#define reply ((ContextReply *) request)
    ProcessId nameserverpid;

    request->requestcode = GET_FILE_NAME;
    request->nameindex = 0;
    request->instanceid = instanceid;
    request->namecontextid = 0;
    request->nameptr = name;
    request->namelength = namelength;

    Send(request, serverpid);

    if( reply->replycode != OK )
      {
	*name = NULL;	/* mark string as zero length */
        return (reply->replycode);
      }

    /* else terminate the string */
    name[reply->namelength] = NULL;
    return (reply->replycode);

#undef reply

  } /* GetFileName */
