/*
 * Function-call interface to GET_CONTEXT_NAME message.  Gets the absolute
 * name of the context specified by the given ContextPair.
 *
 * Returns a null terminated string in name.
 * namelength is passed in as the maximum length of the name.
 */

#include "Vnaming.h"

SystemCode GetContextName(name, namelength, context)
    char *name;
    unsigned namelength;
    ContextPair context;
  {
    Message msg;
    register ContextRequest *request = (ContextRequest *) msg;
#define reply ((ContextReply *) request)

    request->requestcode = GET_CONTEXT_NAME;
    request->nameindex = 0;
    request->context = context;
    request->namecontextid = 0;
    request->nameptr = name;
    request->namelength = namelength - 1;

    Send( request, context.pid );

    if( reply->replycode != OK )
      {
	*name = NULL;	/* mark string as zero length */
        return (reply->replycode);
      }

    /* else terminate the string */
    name[reply->namelength] = NULL;
    return( reply->replycode );

#undef reply

  } /* GetContextName */
