/* DefineTempArea()
 * Try to make sure "[tmp]" is well-defined.
 */
#include <Venviron.h>

extern SystemCode GetContextId(), DefineLocalName();
extern char *ResolveLocalName();

SystemCode
DefineTempArea()
  {
    ContextPair context;
    char *t = ResolveLocalName("[tmp]");
    if ( t == NULL || GetContextId(t, &context) != OK )
      {
	/* Define [tmp] to be something sensible */
	if ( DefineLocalName("[tmp]", "[storage/local]/tmp") != OK &&
	     DefineLocalName("[tmp]", "/tmp") != OK &&
	     DefineLocalName("[tmp]", "[storage/any]/tmp") != OK )
	    return
	     DefineLocalName("[tmp]", ".");
      }
    return OK;
  }
