/*
 * Make a fresh copy of the environment variable list pointed to by 
 *   oldenv and return a pointer to it.  The order of the list is
 *   reversed as it is copied.
 */

#include "Vnamecache.h"

extern char *strsave();

EnvironmentVariable *copyenv(oldenv)
    register EnvironmentVariable *oldenv;
  {
    register EnvironmentVariable *top, *ev;

    ev = NULL;

    while (oldenv)
      {
	top = ev;
    	ev = (EnvironmentVariable *) malloc(sizeof(EnvironmentVariable));
	ev->next = top;
	ev->name = strsave(oldenv->name);
	ev->value = strsave(oldenv->value);
	oldenv = oldenv->next;
      }

    return ev;
  }
