/*
 * ClearLocalNames()
 * Delete all locally-defined aliases from the name cache.
 *  Inefficient; could delete in-line with knowledge of predecessor
 *  in linked list instead of calling NameCacheDelete.
 *
 * Tim Mann 9-11-85
 */

#include "Vnaming.h"
#include "Vgroupids.h"
#include "Vnamecache.h"

extern NameCacheEntry *NameCacheLookup();

ClearLocalNames()
  {
    SystemCode err;
    register NameCacheEntry *ce, *nextce;
    static ContextPair rootcontext =
	 { VCSNH_SERVER_GROUP, GLOBAL_ROOT_CONTEXT } ;

    ce = *PerProcess->namecache;
    while (ce)
      {
	nextce = ce->next;
	if (ce->flags & ALIAS) NameCacheDelete(ce);
	ce = nextce;
      }
  }
