/*
 * clearenv.c
 *
 * Unset all environment variables.
 */

#include "Vnamecache.h"
#include "Vio.h"

clearenv()
  {
    register EnvironmentVariable *ev, *nextev;

    ev = *PerProcess->env;
    *PerProcess->env = NULL;	/* unhook the chain */
    
    /* Free everything in it */
    while (ev)
      {
	nextev = ev->next;	
	free(ev->name);
	/* Can't free old value since someone 
	 *  could have a pointer to it */
	free(ev);
	ev = nextev;
      }
  }
