/*
 * ByteSwapShortCopy()
 *
 *	Swap "n" bytes in 16-bit (half-)words, copying from the source to 
 *	the destination.
 *
 * IMPORTANT: This routine allows "from" == "to", although not general
 *		overlap.
 *
 */

#define	UR_BITS	3		/* lg(# of times loop unrolled) */
#define	UR_TIMES (1<<UR_BITS)	/* # of times loop unrolled */
#define	UR_MASK	(UR_TIMES - 1)

ByteSwapShortCopy(from, to, n)
register char *from, *to;
register int n;
{
	register unsigned long temp;
	
	n >>= 1;	/* n /= 2 */
	n++;
	while ((--n)&UR_MASK) {	/* until remainder is multiple of UR_TIMES */
		temp = *from++;
		*to++ = *from++;
		*to++ = temp;
	}
	
	n >>= UR_BITS;	/* n /= UR_TIMES, # of times for unrolled loop */
	while (--n >= 0) {

#define	STEP	temp = *from++;*to++ = *from++;*to++ = temp;

#if	UR_BITS == 0
		STEP
#endif	UR_BITS == 0

#if	UR_BITS == 1
		STEP
		STEP
#endif	UR_BITS == 1

#if	UR_BITS == 2
		STEP
		STEP
		STEP
		STEP
#endif	UR_BITS == 2

#if	UR_BITS == 3
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
#endif	UR_BITS == 3

#if	UR_BITS == 4
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
		STEP
#endif	UR_BITS == 4

	}
} /* ByteSwapShortCopy */


ByteSwapShortInPlace(ptr, n)
    char *ptr;
    int n;
  {
    ByteSwapShortCopy(ptr, ptr, n);
  }


/* For backward compatibility only! */
swab(from, to, n)
    char *from, *to;
    int n;
  {
    ByteSwapShortCopy(from, to, n);
  }
