/* Unix-compatible bcopy; works (slowly) for overlapping byte strings */
/* Assumes that (the optimized) Copy copies increasing addresses. */

bcopy(from, to, size)
    char *from, *to;
    int size;
  {
    if (from >= to || from + size <= to)
	Copy(to, from, size);
    else
	CopyDownwards(to, from, size);
  }

CopyDownwards(to, from, size)
    register char *from, *to;
    register int size;
  {
    from += size;
    to += size;
    while (--size >= 0) *--to = *--from;
  }
