/*
 *  locking.h must define the following operations:
 *
 *  LockTotal()     - lock completely from completely unlocked
 *  UnlockTotal()   - unlock completely (from any state)
 *  LockPartial()   - lock completely from either completely 
 *				or partially unlocked
 *  UnlockPartial() - if totally locked, move to partially unlocked
 *		      if partially locked, move to totally unlocked
 *				
 *	Locking is done via a pseudo-semaphore; a locked-out process
 *	    delays 1 click and tries again.
 *	The lock may be partially released to allow adding space to the
 *	    arena; only such additions may be done by other processes
 *	    until the process holding the partial lock releases it.
 *	This implementation will work in a multiprocessor, but it is
 *	    susceptible to starvation of a waiting process.
 */

static unsigned AccessLock = 0;

#define UnlockTotal()	{ asm("	clrb	AccessLock"); }
#define UnlockPartial()	{ asm(" bclr	#7,AccessLock"); }

#define LockTotal() \
  {					\
    asm("3$:	tas	AccessLock");	\
    asm("	jeq	1$");		\
    /* not completely unlocked */	\
    asm("	jpl	2$");		\
    /* only partially locked; so restore it to that state */	\
    UnlockPartial();			\
    asm("2$: ");			\
    /* the lock is restored to its original state; now delay */	\
    Delay(0,1);				\
    asm("	jra	3$");		\
					\
    asm("1$: ");			\
    /* the lock is acquired; set so that partial locking will hold */	\
    asm("	bset	#0,AccessLock");	\
  }

#define LockPartial()	\
  {					\
    asm("5$:	tas	AccessLock");	\
    asm("	jpl	4$");		\
    /* was not completely unlocked; so delay */	\
    Delay(0,1);				\
    asm("	jra	5$");		\
					\
    asm("4$: ");			\
    /* the lock is acquired; partial bit remains in original state */	\
  }

