
#include <Venviron.h>
#include <Vgroupids.h>

GroupId CreateGroup( pid, type )
register GroupId type;
register ProcessId pid;
  {
    register GroupId gid;
    GroupId tmp;
    MsgStruct msg;
    KernelRequest *req = (KernelRequest *) &msg;
    extern Process_id Kernel_Process_Pid;

    if( pid == 0 ) pid = GetPid( ACTIVE_PROCESS, LOCAL_PID );

    do
      {
	/* Generate a group id. */
	GetTime( &tmp );
	gid = tmp + (unsigned) pid;
	gid &= ~(REMOTE_ALIAS_PROCESS|STATIC_GROUP_BIT|UNRESTRICTED_GROUP_BIT|LOCAL_GROUP_BIT);

	if( type & LOCAL_GROUP_BIT )
	    gid = ( (pid & 0xFFFE0000) | LOCAL_GROUP_BIT | (gid & 0xFFFF) );
	if( type & UNRESTRICTED_GROUP_BIT ) gid |= UNRESTRICTED_GROUP_BIT;
	gid |= GROUP_ID_BIT;

	req->opcode = CREATE_GROUP;
	req->pid = pid;
	req->unspecified[0] = gid;
	Send( req, Kernel_Process_Pid );
      }
    while ( req->opcode == RETRY );

    if ( req->opcode == OK ) return( gid );
    return( 0 );
  }
