
| V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann, Lance Berc
|
|  This file assembles into the library routines used to call
|    kernel operations.
|

| Trap assignments:
|
|	Send		0
|	_Receive	2
|	ReplyWithSeg	3
|	Forward		1
|	GetReply	12

| Send( msg, pid )
| MsgStruct *msg;
| ProcessId pid;
|
| Invocation:		Return:
| d0: Destination pid	d0: Replier's pid

	.text
	.globl	Send
Send:
	moveml	#/3F3E, sp@-	| Save registers
	movl	sp@(48), a5	| Pick up pointer to message
	movl	sp@(52), d0	| Load pid argument
	moveml	a5@, #/07F8	| Load message into registers
	trap	#0		| Trap to kernel
	movl	sp@(48), a5	| Pick up pointer to message
	moveml	#/07F8, a5@	| Save return message
	moveml	sp@+, #/7CFC	| Restore registers
	rts

| _Receive( msg, ptr, size, pid )
| MsgStruct *msg;
| char *ptr;
| unsigned long *size;
| ProcessId pid;
|
| Invocation:		Return:
| d0: Specific pid	d0: Sender's pid
| d2: Segment size	d1: Segment size
| a4: Segment ptr

	.text
	.globl	_Receive
_Receive:
	moveml	#/3F3E, sp@-	| Save registers

	movl	sp@(56), a4	| Pointer to size (not a parameter)
	movl	a4@, d2		| Segment size
	movl	sp@(52), a4	| Segment ptr
	movl	sp@(60), d0	| Pid
	trap	#2
	movl	sp@(56), a4	| Reload pointer to segment size
	movl	d1, a4@		| Store segment size
	movl	sp@(48), a5
	moveml	#/07F8, a5@
	moveml	sp@+, #/7CFC
	rts

| ReplyWithSeg( msg, pid, ptr )
| MsgStruct *msg;
| ProcessId pid;
| char *ptr;
|
| Invocation:		Return:
| d1: Dest pid
| a3: Segment ptr

	.text
	.globl	ReplyWithSeg
ReplyWithSeg:
	moveml	#/3F3E, sp@-	| Save registers
	movl	sp@(52), d1	| Load pid argument
	movl    sp@(56), a3	| Return segment ptr
	movl	sp@(48), a5
	moveml	a5@, #/07F8
	trap	#3
	moveml	sp@+, #/7CFC
	rts

| Forward( msg, from_pid, to_pid )
| MsgStruct *msg;
| ProcessId from_pid;
| ProcessId to_pid;
|
| Invocation:		Return:
| d0: Dest pid		d0: Zero if local forward failed
| d1: Original sender

	.text
	.globl	Forward
Forward:
	moveml	#/3F3E, sp@-
	movl	sp@(48), a5
	movl	sp@(52), d1	| from_pid
	movl	sp@(56), d0	| to_pid
	moveml	a5@, #/07F8
	trap	#1
	moveml	sp@+, #/7CFC
	rts

| GetReply( msg, ticks )
| MsgStruct *msg;
| unsigned long ticks;
|
| Invocation:		Return:
| d1: Timeout count	d0: Replier pid
|     (in clicks)	    (zero if timeout)

	.text
	.globl	GetReply
GetReply:
	moveml	#/3F3E, sp@-
	movl	sp@(52), d1	| Timeout value
	trap	#12
	movl	sp@(48), a5
	moveml	#/07F8, a5@
	moveml	sp@+, #/7CFC
	rts
