/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * Write
 */

#include "Vioprotocol.h"


Write( fad, buffer, bytes )  register File *fad; char *buffer; int bytes;

   /* Write the specified number of bytes from the buffer into the
    * file instance specified by fad. The number of bytes written is
    * returned.
    */
  {
    Message	msg;
    register IoRequest	*request = (IoRequest *) msg;
    register IoReply	*reply = (IoReply *) msg;
    register char *buf, *buf1;
    register unsigned r, count;

    do
      {
	request->requestcode = WRITE_INSTANCE;
	request->fileid = fad->fileid;
	request->bytecount = bytes;
        request->blocknumber = fad->block;

	count = bytes;
        if ( count <= IO_MSG_BUFFER )
	  {
	    request->requestcode = WRITESHORT_INSTANCE;
	    buf = (char *) request->shortbuffer;
	    buf1 = buffer;
	    for( r = 0; r < count; ++r ) *buf++ = *buf1++;
	  }
	else request->bufferptr = buffer;

	Send( request, fad->fileserver );

	r = reply->replycode;
      }
    while (r == RETRY);
    fad->lastexception = r;
    if( r == NONEXISTENT_PROCESS || r == KERNEL_TIMEOUT )
	return( 0 );
    else
	count = reply->bytecount;

    return( count );
  }
