/* routines to write big-endian integers to a byte file.
 * This file should work on \both/ little- and big-endian machines.
 * It's assumed that int==long; and that integers are binary, 2's complement
 * and the machine is byte-addressable. It's easy to get around these
 * assumptions, but it seems not to be worthwhile.
 * Per Bothner, December 1984.
 */
#include <stdio.h>
#define u_char unsigned char
#define u_long unsigned long
#define s_char char

PutSigned1(i, fp)
    long i; register FILE *fp;
  {
    putc(i, fp);
  }

PutSigned2(i, fp)
    long i; register FILE *fp;
  {
    putc(i >> 8, fp);
    putc(i, fp);
  }

PutSigned3(i, fp)
    long i; register FILE *fp;
  {
    putc(i >> 16, fp);
    putc(i >> 8, fp);
    putc(i, fp);
  }

PutSigned4(i, fp)
    long i; register FILE *fp;
  {
    putc(i >> 24, fp);
    putc(i >> 16, fp);
    putc(i >> 8, fp);
    putc(i, fp);
  }

/* Unsigned vesion are included for symmetry, though they identical on
 * "normal" machines.
 */
PutUnsigned1(i, fp)
    long i; register FILE *fp;
  {
    putc(i, fp);
  }

PutUnsigned2(i, fp)
    long i; register FILE *fp;
  {
    putc(i >> 8, fp);
    putc(i, fp);
  }

PutUnsigned3(i, fp)
    u_long i; register FILE *fp;
  {
    PutSigned3(i, fp);
  }

PutUnsigned4(i, fp)
    u_long i; register FILE *fp;
  {
    PutSigned4(i, fp);
  }
