/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * OpenStr
 */

#include "Vioprotocol.h"


File *OpenStr( str, size, error ) 
    unsigned char *str; unsigned size; SystemCode *error;

  /* Make the specified string look like a file.
   * The file is fixed length with one block of size "size"
   * and the end-of-file set to the end of this block.
   * The string actually becomes the buffer in the FAD.
   * As a result, there is no discrepancy between the state of the
   * data in the "buffer" and the data in the "file", so the
   * MODIFIED_BUFFER bit in the FAD state need never be set on
   * and file->currsize is initially and always equal to "size".
   * A file opned by OpenStr is identified as such by the fileserver
   * being equal to 0.
   */
  {
    extern File *TeamFileList;
    register File *file;

    if ( (file = (File *) calloc(1,sizeof(File))) == NULL )
      {
	if (error) *error = NO_MEMORY;
	return( NULL );
      }

    file->buffer = str;
    file->type = READABLE + WRITEABLE + FIXED_LENGTH;
    file->blocksize = MAXBYTES;	/* just using size loses if size=0 */
    file->lastblock = 0;
    file->lastbytes = size;
    file->fileserver = 0;
    file->current = str;
    file->currsize = size;
    file->readLimit = str + size;
    file->writeLimit = str + size;

    file->link = TeamFileList;
    TeamFileList = file;

    if (error) *error = OK;
    return( file );
  }
