@Heading(Register Interface to the V Kernel)
@center(David Cheriton
Computer Science Department
Stanford University
@value[date])

This document defines the register interface of the V kernel for
the Motorola 68000 and the Vax architectures.
The interprocess communication primitives such as Send, etc. continue
as defined in the V reference manual.
(Except that we are changing the definition of ReplyWithSegment.)

Note that
@programexample{CopyTo( destpid, dest, src, count )}
and
@programexample{CopyFrom( srcpid, dest, src, count )}
are Send operations to the kernel server associated with 
destpid or srcpid in the format of a read or write operation
where srcpid is the instance, blocknumber is the remote address,
bufferptr is the local address and bytecount is the count.
The delivery field indicates the data to be transferred in invocation
and indicates the data actually transferred on return.
Each Send operation is limited to 32 kilobytes.
A CopyTo or CopyFrom operation of more than than must be realized as
multiple send operations.

@subheading(Process Descriptor)

This assumes that the process descriptor and interkernel protocol
will be changed so that
@begin(programexample)
	ProcessId	blocked_on;
	ProcessId	pid;
	ProcessId	forwarder;
	MsgStruct	msg;
@end(programexample)
are contiguous.
Thus, there are 11 long words can be loaded or stored for the message register
interface in a single operation.

@subheading(Motorola 68000 Interface)

Only A6 and A7 are preserved across the trap.

@programexample{Send( msg, pid ) }
On Send,
@begin(description)
d0@\receiver for message.

d1@\set to zero - reserved for timeout value?

d2@\not used - corresponds to forwarder - set by kernel

d3-a2@\8-word message.
@end(description)
On return from Send trap,
@begin(description)
d0@\replier to message.

d1@\Not used - reserved.

d2@\last forwarder.

d3-a2@\8-word message.
@end(description)

@programexample{Receive( msg ) }
and
@programexample{ReceiveWithSegment( msg, segbuf, segsize )}
On invocation,
@begin(description)
d0@\Not used.

d1@\zero - indicating receive from any, is pid if ReceiveSpecific.

d2@\segsize for data willing to receive - zero for Receive.

d3-a2@\not used - will contain 8-word reply message.

a3@\not used.

a4@\segbuffer pointer
@end(description)
On return from trap,
@begin(description)
d0@\Pid to which message was addressed, group id if a group send.

d1@\sender in response to receive.

d2@\last forwarder.

d3-a2@\8-word message received from sender.

a3@\Not used.

a4@\Return amount of data in segment received, for compatibility
with current definition of ReceiveWithSegment.
@end(description)

@programexample{ReplyWithSegment( msg, replypid, localptr )}
and
@programexample{Reply( msg, replypid )}
Same as ReplyReceiveWithSegment on invocation,
d1 set on return to indicate successfull reply or not.

@programexample{
ReplyReceiveWithSegment( pid, msg, segptr, segbuf, segsize )}
On invocation,
@begin(description)
d0@\zero - indicating receive from any.

d1@\process to reply to.

d2@\segsize for data willing to receive.

d3-a2@\8-word reply message.

a3@\local pointer for reply segment.

a4@\segbuffer pointer
@end(description)
On return from trap,
@begin(description)
d0@\Pid to which message was addressed, group id if a group send.

d1@\sender in response to receive.

d2@\last forwarder.

d3-a2@\8-word message received from sender.

a3@\ not used.

a4@\amount actually received in segment - for compatibility with
current hackery.
@end(description)
There is no indication when the reply fails.

@programexample{
ReplyReceiveSpecific( replypid, msg, localptr, segbuf, segsize )}
Same as ReplyReceive except d0 is set to process from which to receive
the next message.

@programexample{Forward( msg, frompid, topid )
On invocation,
@begin(description)
d0@\topid.

d1@\frompid.

d2@\not used.

d3-a2@\8-word reply message.
@end(description)
On return from trap,
@begin(description)
d1@\is zero if forward failed locally.
@end(description)

@subheading(VAX Interface)

Again, only pc and stack pointer are preserved across a trap.
