/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * UNIX simulation routine for mktemp.
 *
 * Makes a unique temporary file name according to the given template.
 *  The characters XXXXXX in the template are replaced with an encrypted
 *  form of the calling process's pid, with 4 extra bits thrown in that
 *  are different on each call to mktemp().
 */

#include "Vio.h"

extern char *index();

char *mktemp( filename ) char *filename;
  {
    char *p;
    ProcessId mypid;
    static int unique = 0;
    register int i;
    static char chars[] =
    	"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789=+";

    p = index(filename, 'X');
    mypid = GetPid(ACTIVE_PROCESS, LOCAL_PID);

    i = 0;
    while (i < 5)
      {
	p[i] = chars[mypid & 077];
	mypid >>= 6;
	if (p[++i] != 'X') return filename;  /* robustness */
      }

    p[5] = chars[(unique + mypid) & 077];
    unique += 4;

    return(filename);
  }
