#include "Vio.h"

FlushBuffer( fad, byte)
    register File *fad; char byte;
 
    /* Flush the buffer of the open file specified by fad, and put the
     * byte in the now empty buffer.
     */
 
  {
    if (fad->state & EOF_BYTE)
        return EOF;

    /* If not writeable, complain */
    if (!(fad->type & WRITEABLE))
      {
        fad->state |= EOF_BYTE;
	fad->lastexception = NOT_WRITEABLE;
	return EOF;
      }

    /* Validate buffer, if possible */
    Seek( fad, 0, REL_BYTE );
    if( fad->state & EOF_BYTE )  return EOF;

    /* Get ready to write */
    if ((fad->block == fad->lastblock) && (fad->type & FIXED_LENGTH))
        fad->writeLimit = fad->buffer + fad->lastbytes;
    else
    	fad->writeLimit = fad->buffer + fad->blocksize;

    if( fad->current < fad->writeLimit )
        return *(fad->current)++ = byte;

    /* Current position can't be written */
    fad->state |= EOF_BYTE;
    fad->lastexception = END_OF_FILE;
    return EOF;
  }
