/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * Flush
 */

#include "Vioprotocol.h"


Flush( fad ) register File *fad;

  /* Flush the specified fad.
   * This writes out the contents of the buffer but does not
   * change the current byte position in the file.
   */
  {
    if ( (fad->type & FBLOCK_MODE) ||
         !(fad->type & WRITEABLE) )
	return;

    Seek( fad, 0, FLUSH );

    /* If stream, move to start of next block */
    if ( fad->type & STREAM )
      {
	Seek( fad, fad->lastblock + 1, ABS_BLK);
	fad->writeLimit = fad->buffer + fad->blocksize;
      }
  }

