/*
 * V-System I/O library
 * Copyright (c) 1985, Board of Trustees, Leland Stanford Junior University
 *
 * FillBuffer
 */

#include "Vio.h"

#define BufferValid(fad) \
	( fad->currsize != MAXBYTES || \
	  fad->writeLimit > fad->buffer && fad->current > fad->buffer )

unsigned FillBuffer( fad )
    register File *fad;

   /* Fill the buffer of the open file specified by fad. Return the first
    * character in the buffer or EOF.
    */

   {
      if( fad->state & EOF_BYTE )   return( EOF );

      /* Questionable  hack */
      if ((fad == stdin) && (stdout->type & INTERACTIVE))
	Flush(stdout); /* Flush standard output */

     /*
      * If file is VARIABLE_BLOCK and this was a short block, advance
      *  past the nonexistent part at the end.  In either case, try to
      *  read the current (normalized) block.
      */
      if ( (fad->type&(VARIABLE_BLOCK|READABLE))==(VARIABLE_BLOCK|READABLE) &&
      	   BufferValid(fad) )
          Seek( fad, fad->block + 1, ABS_BLK);
      else
          Seek( fad, 0, REL_BYTE );

      if( fad->state & EOF_BYTE )   return( EOF );	/* Seek failed */

      /* Return the next byte */
      if( fad->current < fad->readLimit )
        return *fad->current++;
      
      /* Error: even after seeking, we didn't manage to get to a valid
       *  position.  This means either we are beyond the end of file,
       *  or the file was not readable. (Or we advanced into a zero-length
       *  block within a variable-block file!  That case is punted for now.)
       */
      fad->state |= EOF_BYTE;
      if (fad->type & READABLE) 
          fad->lastexception = END_OF_FILE;
      else
          fad->lastexception = NOT_READABLE;
      return( EOF );
   }
