/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 *
 * I/O routines that implement the I/O protocol.
 * CreateDuplexInstance
 */

#include "Vnaming.h"
#include "Vioprotocol.h"


SystemCode CreateDuplexInstance( fileserver, fileid, mode, req )
	ProcessId fileserver; InstanceId fileid; int mode;
				CreateDuplexInstanceRequest *req;

  /* Create a duplex instance of the file specified with
   * usage mode and return the reply from the request in req.
   * The reply code is returned by the function.
   * This is only used for creating duplex instances when it is not
   * necessary to set up a FAD for use by other I/O library routines.
   */
  {
    unsigned id;
    register CreateDuplexInstanceReply *reply = (CreateDuplexInstanceReply *) req;
    ProcessId pid;

    req->requestcode = CREATE_DUPLEX_INSTANCE;
    req->fileid = fileid;
    req->filemode = mode;

    Send(req, fileserver);

    return( reply->replycode );
  }
