/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * I/O routines that implement the I/O protocol.
 * CreateInstance
 */

#include "Vnaming.h"
#include "Vioprotocol.h"


ProcessId CreateInstance(name, mode, req)
  char *name;
  int mode;
  CreateInstanceRequest *req;
  /* Create an instance of the file specified by name in the
   * usage mode and return the reply from the request in req.
   * Return the pid of the replier.
   * This is only used for creating instances when it is not
   * necessary to set up a FAD for use by other I/O library routines.
   */
  {
    unsigned id;
    register CreateInstanceReply *reply = (CreateInstanceReply *) req;
    ProcessId pid;

    req->requestcode = CREATE_INSTANCE;
    req->type = 0;
    req->filename = name;
    req->filenamelen = strlen( name );
    req->filenameindex = 0; /* Use the entire name */
    req->filemode = mode;

    return NameSend(req);
  }
