/*
 * V-System library - Copyright (c) 1985 Stanford University
 *
 * Change directory operation.
 */

#include "Vnaming.h"
#define NAME_BUF_SIZE 256

extern SystemCode GetAbsoluteName();

SystemCode ChangeDirectory(name)
    char *name;
  {
    /* Change the working directory for this process
     *   to the specified name */
    register char *namebuf;
    SystemCode err;
    ContextPair context;

    /* Get the absolute name and context id */
    namebuf = (char *) malloc(NAME_BUF_SIZE);
    strncpy(namebuf, name, NAME_BUF_SIZE);
    if (namebuf[NAME_BUF_SIZE-1] != '\0')
	return BAD_ARGS;  /* name too long */
    err = GetAbsoluteName(namebuf, NAME_BUF_SIZE, &context);

    if (err != OK) return err;
    if (context.pid == 0) return INVALID_CONTEXT;  /* not a context */

    /* Reset current working context */
    if (PerProcess->ctxname) free(PerProcess->ctxname);
    PerProcess->ctx = context;
    PerProcess->ctxname = namebuf;

    return OK;
  }


/* Unix emulation */
chdir(name)
    char *name;
  {
    return ( ChangeDirectory(name)==OK ? 0 : -1 );
  }
