/*
 * ipl.h : contains - names for microVAX privileged registers
 *		    - definitions for fields in the PSL
 *		    - function codes written to the txdb register
 *		    - names of interrupt priority levels
 *		    - formats of vectors in the SCB
 */

/*
*	The mnemonics for the microVAX privileged registers
*/
asm("	.set	ksp, 0x0");
asm("	.set	esp, 0x1");
asm("	.set	ssp, 0x2");
asm("	.set	usp, 0x3");
asm("	.set	isp, 0x4");
asm("	.set	p0br, 0x8");
asm("	.set	p0lr, 0x9");
asm("	.set	p1br, 0xa");
asm("	.set	p1lr, 0xb");
asm("	.set	sbr, 0xc");
asm("	.set	slr, 0xd");
asm("	.set	pcbb, 0x10");
asm("	.set	scbb, 0x11");
asm("	.set	ipl, 0x12");
asm("	.set	astlvl, 0x13");
asm("	.set	sirr, 0x14");
asm("	.set	sisr, 0x15");
asm("	.set	cmierr, 0x17");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	iccs, 0x18");
asm("	.set	nicr, 0x19");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	icr, 0x1a");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	todr, 0x1b");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	csrs, 0x1c");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	csrd, 0x1d");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	csts, 0x1e");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	cstd, 0x1f");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	rxcs, 0x20");
asm("	.set	rxdb, 0x21");
asm("	.set	txcs, 0x22");
asm("	.set	txdb, 0x23");
asm("	.set	tbdr, 0x24");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	cadr, 0x25");	/* Used on uVAX I; no-op on uVAX II  */
asm("	.set	mcesr, 0x26");	/* Used on uVAX I; no-op on uVAX II  */
asm("	.set	caer, 0x27");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	accs, 0x28");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	accr, 0x29");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	savisp, 0x29");	/* uVAX II only - n.b. no accr	     */
asm("	.set	savpc, 0x2a");	/* uVAX II only			     */
asm("	.set	savpsl, 0x2b");	/* uVAX II only			     */
asm("	.set	wcsa, 0x2c");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	wcsb, 0x2d");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sbifs, 0x30");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sbis, 0x31");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sbisc, 0x32");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sbimt, 0x33");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sbier, 0x34");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sbita, 0x35");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sbiqc, 0x36");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	ioreset, 0x37");
asm("	.set	mapen, 0x38");
asm("	.set	tbia, 0x39");
asm("	.set	tbis, 0x3a");
asm("	.set	tbdata, 0x3b");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	mbrk, 0x3c");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	pmr, 0x3d");	/* Unused/Unimplemented/Inaccessible */
asm("	.set	sid, 0x3e");
asm("	.set	tbchk, 0x3f");

/*
*	PSL definitions and bit masks 
*	  'v' for offset to bit field,
*	  's' for size   of bit field (otherwise 1),
*	  'c' for constants that go in bit fields
*/
asm("	.set	psl$c_kernel,	0");
asm("	.set	psl$c_exec,	1");
asm("	.set	psl$c_super,	2");
asm("	.set	psl$c_user,	3");

asm("	.set	psl$v_c,	0");
asm("	.set	psl$v_v,	1");
asm("	.set	psl$v_z,	2");
asm("	.set	psl$v_n,	3");
asm("	.set	psl$v_tbit,	4");
asm("	.set	psl$v_iv,	5");
asm("	.set	psl$v_fu,	6");
asm("	.set	psl$v_dv,	7");
asm("	.set	psl$v_ipl,	16");
asm("	.set	psl$s_ipl,	5");
asm("	.set	psl$v_prvmod,	22");
asm("	.set	psl$s_prvmod,	2");
asm("	.set	psl$v_curmod,	24");
asm("	.set	psl$s_curmod,	2");
asm("	.set	psl$v_is,	26");
asm("	.set	psl$v_fpd,	27");
asm("	.set	psl$v_tp,	30");
asm("	.set	psl$v_cm,	31");

/*
*	MicroVAX I ONLY: Magic codes written into txdb
*/
asm("	.set	txdb_magic,		0xf00		 ");
asm("	.set	txdb_boot,		0x02 + txdb_magic");
asm("	.set	txdb_clear_restart_flag,0x03 + txdb_magic");
asm("	.set	txdb_clear_boot_flag,	0x04 + txdb_magic");
asm("	.set 	txdb_console_halt,	0x05 + txdb_magic");
#define	STOP_MVAX_I	asm("	mtpr	$txdb_console_halt,	$txdb");

/*
*	The IPL values used by the microVAX.
*
*	Note:  When any Q-22 Bus interrupt (IRQ4-7) is serviced, the IPL
*	       is raised to 0x17.
*/
#define	IntNone		0x1f
#define	IntPwrFail	0x1e
#define	IntMemWrite	0x1d	/* uVAX I only  */
#define	IntIRQ7		0x17
#define	IntIntvlTimer	0x16
#define	IntIRQ6		0x16
#define	IntIRQ5		0x15
#define	IntRxConsole	0x14
#define	IntTxConsole	0x14
#define IntIPDoorbell	0x14	/* uVAX II only */
#define	IntIRQ4		0x14
#define	IntSoftware	0x0f	/* all of 01-0f */


/*
*	The System Control Block values
*/
typedef struct {
	int	(*vec[0x100])();
} SCB_t;

#define	SetIntVec(SCBB, VecX, fn)	SCBB[VecX] = 2 + (int)fn

#define	VecMachineChk		1
#define	VecKernStackInval	2
#define	VecPwrFail		3
#define	VecResPrivInstrn	4
#define	VecXFC			5
#define	VecOperandReserved	6
#define	VecAddrModeReserved	7
#define	VecAccessCntlViol	8
#define	VecXlationInval		9
#define	VecTracePending		10
#define	VecBreakPoint		11
#define	VecArithmetic		13
#define	VecCHMK			16
#define	VecCHME			17
#define	VecCHMS			18
#define	VecCHMU			19
#define	VecBusTimeout		24
#define	VecBegSoftware		25
#define	VecEndSoftware		47
#define	VecIntervalTimer	48
#define	VecUndoneEMT		50
#define	VecDoneEMT		51
#define	VecRxConsole		62
#define	VecTxConsole		63
#define	VecQ22Base		128
