/* Publically-used (as68, debug, ?) definitions from the calc language.
 * Per Bothner, September 1984.
 */

#ifndef TDProc
typedef long Object;
#define TDProc 0xA8	/* tag for procedure with descriptor */
#define HasPType(x, type) (((long)(x) & 0xFF000000) == ((type) << 24))
#define ArgNoDefaults 0x81000000
#endif

typedef struct /* Parameter descriptor */
  {
    char *name;
    Object type;	/* 0 if unspecified type */
    Object defaultVal; /* ArgNoDefaults if no default allowed */
    short extra;
    short bits;
#define ArgReleased 1
#define ArgNonObject 2
  } ArgDesc;

typedef struct ProcDesc /* Procedure descriptor */
  {
    unsigned char type;	/* see below for possible values */
    unsigned char bits;
#define ProcPrefix 1	/* if no left argument (postfix) */
#define ProcSaveEnv 8	/* when evaluating, must save env */
#define ProcHasEnv 16	/* contains a pointer to the current env */
#define ProcNamed 32	/* p[-2] is a print-name for the procedure */
#define ProcNullCall 64	/* call procedure even if no args */
    unsigned char trailParams; /* 0 unless variable # of params */
    unsigned char nParams;/* # of params (if variable: fixed params + 1) */
    Object sLinkType;	/* NULL if not needed */
    struct ProcDesc *prefixedDesc;
    ArgDesc parm[1];
/*if variable # of params, last ArgDesc describes Array argument of remainder*/
  } ProcDesc;
