/* modedata.h */

#ifndef MODEDATA
#define MODEDATA

typedef struct
  {
    /* input or output mode bits */
    unsigned		mode;

#ifndef LITTLE_ENDIAN
    /* read back position */
    unsigned short	startX;
    unsigned short	startY;
    unsigned short	stopX;
    unsigned short	stopY;

    short		symbol;

    /* file type */
    unsigned char	fileType;
    char		zoomable;

    /* file size, undefined for structured graphics files */
    unsigned short	minX;
    unsigned short	minY;
    unsigned short	maxX;
    unsigned short	maxY;

    /* writer of the file, if not == 0, then the file is blocked */
    ProcessId		writer;

#else   LITTLE_ENDIAN
    unsigned short	startY;
    unsigned short	startX;
    unsigned short	stopY;
    unsigned short	stopX;
    char		zoomable;
    unsigned char	fileType;
    short		symbol;
    unsigned short	minY;
    unsigned short	minX;
    unsigned short	maxY;
    unsigned short	maxX;
    ProcessId		writer;

#endif  LITTLE_ENDIAN

  } ModeDataType;

#endif  MODEDATA
