/* Vsystem version of the Berkeley 4.2 <sys/dir.h> file.
 */

#include <Vio.h>
#include <Vdirectory.h>
#define	MAXNAMLEN MAX_NAME_LENGTH
struct	direct {
	unsigned short	d_namlen;	/* length of string in d_name */
	char		*d_name;	/* name must be no longer than this */
};

/*
 * Definitions for library routines operating on directories.
 */
typedef struct _dirdesc {
	File	*dd_fd;
	struct direct dd_dp;
	ArbitraryDescriptor dd_buf;
} DIR;

#ifndef NULL
#define NULL 0
#endif
extern	DIR *opendir();
extern	struct direct *readdir();
extern	long telldir();
extern	void seekdir();
#define rewinddir(dirp)	seekdir((dirp), (long)0)
extern	void closedir();
