/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * V Service Server include file
 */


/*
 * Request codes
 */

#define REGISTER_OBJECT 0x1804
#define CREATE_SELECTION_INSTANCE 0x1c02

#define SERVICE_SERVER_ALIVE 0x2201


/* Server name types */
#define STRING_NAME 0
#define PID_NAME 1


#define ServiceServerBroadcastInterval 30
				/* Broadcast interval used for sending 
				   "breath-of-life" messages. */


typedef struct			/* Registration/unregistration request
				    message format. */
  {
#ifndef LITTLE_ENDIAN
    SystemCode requestcode;
    short nameType;
    short nameIndex;
    short typeIndex;
#else LITTLE_ENDIAN
    short nameType;
    SystemCode requestcode;
    short typeIndex;
    short nameIndex;
#endif LITTLE_ENDIAN
    ProcessId ownerPid;
    unsigned int unspecified[3];
    char *bufferptr;
    unsigned bytecount;
  } RegisterObjectRequest;

typedef struct			/* Registration reply message format. */
  {
#ifndef LITTLE_ENDIAN
    SystemCode replycode;
    InstanceId objectId;
#else LITTLE_ENDIAN
    InstanceId objectId;
    SystemCode replycode;
#endif LITTLE_ENDIAN
  } RegisterObjectReply;

typedef struct			/* Select objects request message format. */
  {
#ifndef LITTLE_ENDIAN
    SystemCode requestcode;
    short patternIndex;
    short patternFcn;
    short howMany;
#else LITTLE_ENDIAN
    short patternIndex;
    SystemCode requestcode;
    short howMany;
    short patternFcn;
#endif LITTLE_ENDIAN
    unsigned unspecified[4];
    char *bufferptr;
    unsigned bytecount;
  } SelectObjectsRequest;

typedef struct			/* Selection reply message format. */
  {
#ifndef LITTLE_ENDIAN
    SystemCode replycode;
    InstanceId selectionId;
#else LITTLE_ENDIAN
    InstanceId selectionId;
    SystemCode replycode;
#endif LITTLE_ENDIAN
  } SelectObjectsReply;

typedef struct			/* Update request message format. */
  {
#ifndef LITTLE_ENDIAN
    SystemCode requestcode;
    short pleaseUpdate;
#else LITTLE_ENDIAN
    short pleaseUpdate;
    SystemCode requestcode;
#endif LITTLE_ENDIAN
  } ServiceServerRequest;
