/*
 * Distributed V Kernel
 * Copyright (c) 1983 by Stanford University, all rights reserved.
 *
 * QueryKernel operation manifests and types.
 */

#ifndef QKERNEL
#define QKERNEL

/* Request message format */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    unsigned short requestcode;		/* must be QUERY_KERNEL */
    unsigned short groupSelect;
#else LITTLE_ENDIAN
    unsigned short groupSelect;
    unsigned short requestcode;
#endif LITTLE_ENDIAN
    ProcessId pid;
    unsigned filler[6];
  } 
QueryKernelRequest;


/* Group selection codes */
#define MACHINE_CONFIG		1
#define PERIPHERAL_CONFIG	2
#define MEMORY_STATS		3
#define KERNEL_CONFIG		4
#define KERNEL_STATS		5
#define LOGICAL_HOST_QUERY	6  /* Check if given logical host is local. */

/* Machine configuration group */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    unsigned short replycode;
    unsigned short filler;
    unsigned char processor;	/* Processor type code */
    unsigned char machine;	/* Machine type code */
    unsigned short confreg;	/* Config register contents, if applicable */
    unsigned memory;		/* Bytes of physical memory (total) */
    unsigned fastMemory;	/* For SUN, bytes of onboard memory */
    unsigned slowMemory;	/* For SUN, bytes of multibus mem */
    unsigned reserved[3];
#else LITTLE_ENDIAN
    unsigned short filler;
    unsigned short replycode;
    unsigned short confreg;	/* Config register contents, if applicable */
    unsigned char machine;	/* Machine type code */
    unsigned char processor;	/* Processor type code */
    unsigned memory;		/* Bytes of physical memory (total) */
    unsigned fastMemory;	/* For SUN, bytes of onboard memory */
    unsigned slowMemory;	/* For SUN, bytes of multibus mem */
    unsigned reserved[3];
#endif LITTLE_ENDIAN
  }
MachineConfigurationReply;

/* - Processor types */
#define PROC_FAMILY		0xF0	/* mask to see family */
#define PROC_LITTLE_ENDIAN	0x10	/* odd families are little-endian */
#define PROC_FAM_68000		0x00	/* MC68000 family */
#define PROC_MC68000		0x01
#define PROC_MC68008		0x02
#define PROC_MC68010		0x03
#define PROC_MC68012		0x04
#define PROC_MC68020		0x05
#define PROC_MC68030		0x06
#define PROC_FAM_VAX11		0x10	/* VAX family */
#define PROC_VAX11_725		0x12
#define PROC_VAX11_730		0x14
#define PROC_VAX11_750		0x16
#define PROC_VAX11_780		0x18
#define PROC_VAX11_782		0x1A
#define PROC_UVAX2		0x1C
#define PROC_UVAX1		0x1E

#define NUM_PROC_FAMILIES	2
#define PROC_FAMILY_SHIFT	4

/* - General machine types
 *     Not quite the same thing as processor type.
 *     We distinguish Vax models by processor type,
 *     while various 68000-family-based machines may
 *     use the same processor chip, but have different MMU's, etc.
 */	
#define MACH_STANFORD_SUN	1
#define MACH_CADLINC_SUN	2
#define MACH_SMI_SUN1		3
#define MACH_SMI_SUN15		4	/* Sun 1.5 */
#define MACH_SMI_SUN2		5
#define MACH_IRIS		6
#define MACH_FORWARD_SUN	7	/* Forward Tech Gateway Series */
#define MACH_SMI_SUN3		8
#define MACH_VAX		10


/*  Peripheral group */
/*  - Warning: peripheral codes are not guaranteed to be packed densely
 *    into the array in the reply message -- there can be gaps, filled
 *    in by PRF_NONE codes.  (This is because of byte-ordering problems).
 *    So it is NOT correct to stop at the first PRF_NONE when searching the
 *    array for a particular code.
 */
#define MAX_PERIPHERALS 28  /* just enough to fill up the message */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    unsigned short replycode;
    unsigned short filler;
#else LITTLE_ENDIAN
    unsigned short filler;
    unsigned short replycode;
#endif LITTLE_ENDIAN
    unsigned char peripheral[MAX_PERIPHERALS];
  }
PeripheralConfigurationReply;

/* - Filler for unused array positions*/
#define PRF_NONE		0

/* - Console keyboards */
#define PRF_CONSOLE_CADLINC	1
#define PRF_CONSOLE_SMI100	2
#define PRF_CONSOLE_TERMINAL	3
#define PRF_CONSOLE_SMI120	4
#define PRF_CONSOLE_SMI3	4		/* Sun-3 keyboard */
/* - Mice */
#define PRF_MOUSE_CADLINC	10
#define PRF_MOUSE_SMI100	11
#define PRF_MOUSE_IRIS		12
#define PRF_MOUSE_SMI120	13
#define	PRF_MOUSE_QVSS		14
/* - Ethernet boards */
#define PRF_ENET_3MBIT		20		/* 3 meg ethernet */
#define PRF_ENET_3COM		21		/* 10 meg ethernet */
#define PRF_ENET_EXCELAN	22
#define PRF_ENET_INTERLAN	23
#define PRF_ENET_DEUNA		24
#define PRF_ENET_SMI10		25
#define PRF_ENET_MEIS		26
#define PRF_ENET_DEQNA		27
#define PRF_ENET_SUN50		28
#define PRF_ENET_CMC		29
#define PRF_ENET_SUNIE		28		/* SMI intel82586 chip */

/* - Frame buffer stuff */
#define PRF_FRAMEBUFFER_SMI100	30
#define PRF_FRAMEBUFFER_SMI120	31
#define PRF_FRAMEBUFFER_QVSS	32
#define PRF_FRAMEBUFFER_SUN3	33
/* - Odds and ends */
#define PRF_GPIB_ZIATECH	40
#define PRF_CONFREG		41		/* Has a config register */
/* - Disk controllers */
#define PRF_DISK_INTERPHASE	50		/* Interphase controller */
#define PRF_DISK_XYLOGICS	51		/* Xylogics controller */
#define PRF_DISK_RQDX		52		/* DEC RQDX controller */
/* - Serial ports */
#define PRF_SERIAL_SUNONBOARD	70
#define PRF_SERIAL_SUN8UART	71
#define PRF_SERIAL_SUN16UART	72
#define PRF_SERIAL_VAXDZ11	73
#define PRF_SERIAL_QVSS		74
/* - For historical compatibility */
#define PRF_CADLINC_KEYBOARD	PRF_CONSOLE_CADLINC
#define PRF_SMI100_KEYBOARD	PRF_CONSOLE_SMI100
#define PRF_ASCII_TERMINAL	PRF_CONSOLE_TERMINAL
#define PRF_SMI120_KEYBOARD	PRF_CONSOLE_SMI120
#define PRF_FRAMEBUFFER_SUN1	PRF_FRAMEBUFFER_SMI100
#define PRF_FRAMEBUFFER_SUN2	PRF_FRAMEBUFFER_SMI120
#define PRF_CADLINC_MOUSE	PRF_MOUSE_CADLINC
#define PRF_SMI100_MOUSE	PRF_MOUSE_SMI100
#define PRF_IRIS_MOUSE		PRF_MOUSE_IRIS
#define PRF_SMI120_MOUSE	PRF_MOUSE_SMI120


/* Memory statistics group */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    unsigned short replycode;
    unsigned short filler;
#else LITTLE_ENDIAN
    unsigned short filler;
    unsigned short replycode;
#endif LITTLE_ENDIAN
    unsigned unusedFastMemory;		/* How much unused real memory */
    unsigned unusedSlowMemory;
    unsigned reserved[5];
  }    
MemoryStatisticsReply;


/* Kernel configuration group */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    unsigned short replycode;
    unsigned short ikcType;		/* See below */
    unsigned short maxProcesses;	/* Max number of processes */
    unsigned short maxTeams;		/* Max number of teams */
    unsigned short maxLogicalId;	/* Max logical pid */    
    unsigned short rootPriority;	/* Priority of root process */
    unsigned short initStack;		/* Root process initial stack size */
    unsigned short vmConfig;		/* See below */
    unsigned short versionNumber;	/* Printed as "#xxx" while booting */
    unsigned short reserved[7];
#else LITTLE_ENDIAN
    unsigned short ikcType;		/* See below */
    unsigned short replycode;
    unsigned short maxTeams;		/* Max number of teams */
    unsigned short maxProcesses;	/* Max number of processes */
    unsigned short rootPriority;	/* Priority of root process */
    unsigned short maxLogicalId;	/* Max logical pid */    
    unsigned short vmConfig;		/* See below */
    unsigned short initStack;		/* Root process initial stack size */
    unsigned short versionNumber;	/* Printed as "#xxx" while booting */
    unsigned short reserved[7];
#endif LITTLE_ENDIAN
  }
KernelConfigurationReply;

/* - IKC type */
#define IKC_NONE	0	/* No ikc -- local kernel only */
#define IKC_3MBIT	3	/* ikc on 3 Mbit ethernet */
#define IKC_10MBIT	10	/* ikc on 10 Mbit ethernet */

/* - Virtual Memory configuration */
#define	VM_NONE		0	/* No virtual memory */
#define VM_PRESENT	1	/* Yes, virtual memory available */



/* Kernel statistics group */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    unsigned short replycode;
    unsigned short freePds;	/* How many free process descriptors */
    unsigned short freeTds;	/* How many free team descriptors */
    unsigned short alienCount;	/* How many aliens exist */
#else LITTLE_ENDIAN
    unsigned short freePds;	/* How many free process descriptors */
    unsigned short replycode;
    unsigned short alienCount;	/* How many aliens exist */
    unsigned short freeTds;	/* How many free team descriptors */
#endif LITTLE_ENDIAN
    ProcessId delayQueueHead;	/* Process at head of delay queue */
    unsigned reserved[5];
  }
KernelStatisticsReply;

#endif QKERNEL
