
#include <Venviron.h>

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	sysCode;
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    SystemCode	sysCode;
#endif LITTLE_ENDIAN
    ProcessId	pid;	/* not in use currently */
    unsigned	profileReq;
    unsigned	kernelCount;
    unsigned	userCount;
    Unspec	*tablePtr;
    Unspec	*segmentPtr;
    unsigned	segmentSize;
  }
ProfileRequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode	sysCode;
    short	fill;
#else LITTLE_ENDIAN
    short	fill;
    SystemCode	sysCode;
#endif LITTLE_ENDIAN
    ProcessId	pid;	/* not in use currently */
    unsigned	profileReq;
    Unspec	*tablePtr;
    unsigned	tableSize;
    unsigned	fieldWidth;
    unsigned	profileInUse;
    unsigned	MustBeZero;
  }
ProfileQueryRequest;

#define PROFILE_INIT	0
#define PROFILE_START	1
#define PROFILE_PAUSE	2
#define PROFILE_RESTART 3
#define PROFILE_END	4
#define PROFILE_DATA	5
#define PROFILE_QUERY	6

#define MAX_PROFILE_COUNT 0xFFFF
