/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Vkernel I/O protocol manifests, types and structures.
 */

#ifndef VIOPROTOCOL

#define VIOPROTOCOL

#include "Vio.h"

typedef unsigned long LocalObjectId;

/* Structures defining the template structure of standard I/O request
 * and reply messages.
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    short unsigned	filenameindex;	/* First byte of filename to use */
    short unsigned	type;		/* The type of file to create */
    short unsigned	filemode;
#else LITTLE_ENDIAN
    short unsigned	filenameindex;	/* First byte of filename to use */
    SystemCode		requestcode;
    short unsigned	filemode;
    short unsigned	type;		/* The type of file to create */
#endif LITTLE_ENDIAN
    unsigned		unspecified[3];	/* Server-dependent */
    ContextId		contextid;	/* Context used to interpret name */
    char		*filename;
    unsigned		filenamelen;
  } CreateInstanceRequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    InstanceId		fileid;		/* File instance identifier */
#else LITTLE_ENDIAN
    InstanceId		fileid;		/* File instance identifier */
    SystemCode		replycode;
#endif LITTLE_ENDIAN
    ProcessId		fileserver;	/* Server process for I/O requests */
    unsigned		blocksize;	/* Maximum block size for I/O */
#ifndef LITTLE_ENDIAN
    unsigned short	filetype;	/* Instance type attributes */
    unsigned short	filelastbytes;  /* Number of bytes in last block */
#else LITTLE_ENDIAN
    unsigned short	filelastbytes;  /* Number of bytes in last block */
    unsigned short	filetype;	/* Instance type attributes */
#endif LITTLE_ENDIAN
    unsigned		filelastblock;	/* Laxt block in file */
    unsigned		filenextblock;	/* Next block to read if READABLE STREAM */
    unsigned		unspecified[2];
  } CreateInstanceReply;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    InstanceId		fileid;
    unsigned short	blat;		/* padding */
    unsigned short	filemode;	/* aligned with CreateInstanceReq */
#else LITTLE_ENDIAN
    InstanceId		fileid;
    SystemCode		requestcode;
    unsigned short	filemode;	/* aligned with CreateInstanceReq */
    unsigned short	blat;		/* padding */
#endif LITTLE_ENDIAN
    unsigned		unspecified[6];
  } QueryInstanceRequest;
#define QueryInstanceReply	CreateInstanceReply

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    InstanceId		fileid;
    unsigned short	blat;		/* padding */
    unsigned short	filemode;	/* aligned with CreateInstanceReq */
#else LITTLE_ENDIAN
    InstanceId		fileid;
    SystemCode		requestcode;
    unsigned short	filemode;	/* aligned with CreateInstanceReq */
    unsigned short	blat;		/* padding */
#endif LITTLE_ENDIAN
    unsigned		unspecified[6];
  } CreateDuplexInstanceRequest;
#define CreateDuplexInstanceReply	CreateInstanceReply

/* Number of bytes that will fit in an I/O request or reply message */

#define IO_MSG_BUFFER (sizeof(Message) - (sizeof(SystemCode)+sizeof(InstanceId)+sizeof(char *)+sizeof(unsigned)))

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    InstanceId		fileid;
#else LITTLE_ENDIAN
    InstanceId		fileid;
    SystemCode		requestcode;
#endif LITTLE_ENDIAN
    unsigned		blocknumber;
    char		shortbuffer[IO_MSG_BUFFER-sizeof(char *)];
    char		*bufferptr;
    unsigned		bytecount;
  } IoRequest;

#define instanceowner	blocknumber	/* Used by SetInstanceOwner */
#define releasemode	blocknumber	/* Used by Close */

#define IO_SHORT_BUFFER (sizeof(Message) - (sizeof(SystemCode)+sizeof(InstanceId)+3*sizeof(unsigned)))
/* New form of I/O request message. */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    InstanceId		fill;
#else LITTLE_ENDIAN
    InstanceId		fill;
    SystemCode		requestcode;
#endif LITTLE_ENDIAN
    LocalObjectId	fileid;	/* Now 32-bits. */
    unsigned		blocknumber;
    char		shortbuffer[IO_SHORT_BUFFER-(2*sizeof(char *))];
    unsigned		delivery; /* New field. */
    char		*bufferptr;
    unsigned		bytecount;
  } IORequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    InstanceId		fileid;
#else LITTLE_ENDIAN
    InstanceId		fileid;
    SystemCode		replycode;
#endif LITTLE_ENDIAN
    unsigned		garbage;	/* Filler to match IoRequest format */
    char		shortbuffer[IO_MSG_BUFFER];
    unsigned		bytecount;
  } IoReply;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		replycode;
    InstanceId		fill;
#else LITTLE_ENDIAN
    InstanceId		fill;
    SystemCode		replycode;
#endif LITTLE_ENDIAN
    LocalObjectId	fileid;	/* Now 32-bits. */
    unsigned		blocknumber;
    char		shortbuffer[IO_SHORT_BUFFER-(2*sizeof(char *))];
    unsigned		delivery; /* New field. */
    char		*bufferptr;
    unsigned		bytecount;
  } IOReply;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    InstanceId		fileid;
#else LITTLE_ENDIAN
    InstanceId		fileid;
    SystemCode		requestcode;
#endif LITTLE_ENDIAN
    ProcessId		breakprocess;
    unsigned		unspecified[6];
  } SetBreakRequest;

#endif VIOPROTOCOL
