/*
 * implementation of spin locks
 *
 * for the MC68000
 */

#ifndef V_SPINLOCK
#define V_SPINLOCK

#define SpinLockLocked 0x80000000
#define SpinLockUnlocked 0

typedef long unsigned SpinLockType;
struct SpinLockStruct {
    short lock;
    short count;
  };

#define SpinLockCount(l)	(((struct SpinLockStruct *) &(l))->count)


#define AcquireArgumentSpinLock() \
  do					\
  {					\
    asm("	movl a2,sp@-");		\
    asm("	movl a6@(8),a2");	\
      asm("1$:	tas a2@");		\
      asm("	jeq 2$");		\
      asm("	addqw #1,a2@(2)");	\
      Delay(0,1);			\
      asm("	jra 1$");		\
      asm("2$:	");			\
    asm("	movl sp@+,a2");		\
  } while(0)

#define ReleaseArgumentSpinLock() \
  do					\
  {					\
    asm("	movl a2,sp@-");		\
    asm("	movl a6@(8),a2");	\
    ReleaseGlobalSpinLock(a2@);		\
    asm("	movl sp@+,a2");		\
  } while(0)


#define AcquireGlobalSpinLock(lockName)	\
  do					\
    {					\
      asm("1$:	tas lockName");		\
      asm("	jeq 2$");		\
      asm("	addqw #1,lockName+2");	\
      Delay(0,1);			\
      asm("	jra 1$");		\
      asm("2$:	");			\
    } while(0)

#define ReleaseGlobalSpinLock(lockName) \
  do { asm("	clrb lockName"); } while(0)

extern void AcquireSpinLock();
extern void ReleaseSpinLock();

#endif V_SPINLOCK
