/*
 * Distributed V Kernel - Copyright (c) 1982 by David Cheriton, Willy Zwaenepoel
 *
 *  Manifests and constants relating to V Interkernel Protocol.
 */

#ifndef VIKCDEF
#define VIKCDEF

#include <Venviron.h>

/* Ethertypes for kernel packets */

#ifndef KERNEL_PACKET /* Default kernel packet type for Ethernet */
#define KERNEL_PACKET		XV_KERNEL_PACKET	/* Use xV version */
#define V_KERNEL_PACKET		0x805c			/* V version */
#define XV_KERNEL_PACKET	0x805b			/* xV version */
#endif KERNEL_PACKET

#define V_MULTICAST_ADDRESS { 0x0900, 0x56FF, 0x0000 }

/* V kernel Packet types */

#define remoteSend		1
#define remoteReply		2
#define remoteForward		3
#define remoteReceiveSpecific	4
#define breathOfLife		5
#define remoteGetPid		6
#define remoteGetPidReply	7
#define remoteMoveFromReq	8
#define remoteMoveFromReply	9
#define remoteMoveToReq		10
#define remoteMoveToReply	11
#define nAck			12
#define lhnCollisionCheck	13
#define lhnCollisionReply	14

/*
 * The sender of an IKC packet encodes whether it is big- or little-endian
 *   in the packetType field.  The receiver must check this and, if
 *   necessary, byte-reverse the incoming packet.
 */
#define IKC_LITTLE_ENDIAN   0x8080 /* Both off => big-endian    */
				   /* Both on  => little-endian */
				   /* Other    => bogus packet  */

#ifdef LITTLE_ENDIAN
#define DifferentIKCByteOrder(kpacket) \
 ( (((kPacket *)kpacket)->packetType & IKC_LITTLE_ENDIAN) == 0 )
#else LITTLE_ENDIAN
#define DifferentIKCByteOrder(kpacket) \
 ( (((kPacket *)kpacket)->packetType & IKC_LITTLE_ENDIAN) == IKC_LITTLE_ENDIAN )
#endif LITTLE_ENDIAN

/* swaps a kPacket in place.  Does not affect the appended segment, if any. */
#define SwapIKPacket(p) \
    swabSmall( (char *)(p), 2*sizeof(short));	\
    ByteSwapLongInPlace( (char *)&((kPacket *)(p))->srcPid,	\
			 sizeof(kPacket)-2*sizeof(short))

/* Packet definition */

typedef struct
  {
    unsigned short	packetType;
    unsigned short	sequenceNo;
    Process_id		srcPid;
    Process_id		dstPid;
    Process_id		forwarder;
    unsigned 		userNumber;
    unsigned		length;
    Unspec		*localaddress;	/* local always refers to the sender */
    Unspec		*remoteaddress;
    MsgStruct		msg;
    unsigned char	data[MAX_APPENDED_SEGMENT]; /* data for movefrom moveto */
  } kPacketWithSegment;


typedef struct
  {
    unsigned short	packetType;
    unsigned short	sequenceNo;
    Process_id		srcPid;
    Process_id		dstPid;
    Process_id		forwarder;
    unsigned		userNumber;
    unsigned		length;
    Unspec		*localaddress;	/* local always refers to the sender */
    Unspec		*remoteaddress;
    MsgStruct		msg;
  } kPacket;

#endif VIKCDEF
