#include <Vfont.h>
#include <Vioprotocol.h>
/* 
 * Initialization parameters for CRT controller's registers 0 to 17.
 * Extracted from Ultrix driver for QVSS; these correspond to a VR260 monitor.
 * Older monitors may need their own set of magic numbers.
 */
static short mon19[] =
  {39, 32, 33, 0264, 56, 5, 54, 54, 4, 15, 040, 0, 0, 0, 0, 0};

static FILE *QvssFAD = NULL;
#define CSR_pos 0
#define CADDR_pos 4
#define CDATA_pos 5

UseQvss(raster)
    VRaster *raster;
  { SystemCode error; short i; register unsigned short *scanline_map_addr;
    Message msg; BitUnit *qMSA;
#define IoReq ((IoRequest*)msg)
#define Msg ((MsgStruct*)msg)

    QvssFAD = Open("[device]qvss", FCREATE|FBLOCK_MODE, &error);
    if (error != OK) return 0;

    /* Set CSR regs */
    for (i = 0; i < 16; i++)
      {
	SeekBlock(QvssFAD, CADDR_pos, FILE_BEGINNING);
	Write(QvssFAD, &i, sizeof(short));
	SeekBlock(QvssFAD, CDATA_pos, FILE_BEGINNING);
	Write(QvssFAD, &mon19[i], sizeof(short));
      }

     IoReq->requestcode = QUERY_FILE;
     IoReq->fileid = QvssFAD->fileid;
     Send(msg, QvssFAD->fileserver);
     if (Msg->sysCode != OK) return 0;
     qMSA = (BitUnit*)Msg->unspecified[0];
     if (raster) raster[-1].start = qMSA;

    /* Initialize scanline map */
#define scanline_index 0
    scanline_map_addr = (unsigned short*)(qMSA+(256-2)*1024);
    for (i=0; i < 864; i++)
	 *scanline_map_addr++ = i + scanline_index;

    QvssEnable();
    return 1;
 }

QvssEnable() /* enable video */
  { short i;
    SeekBlock(QvssFAD, CSR_pos, FILE_BEGINNING);
    Read(QvssFAD, &i, sizeof(short));
    i |= 4;
    Write(QvssFAD, &i, sizeof(short));
   }

QvssDisable() /* disable video */
  { short i;
    SeekBlock(QvssFAD, CSR_pos, FILE_BEGINNING);
    Read(QvssFAD, &i, sizeof(short));
    i &= ~4;
    Write(QvssFAD, &i, sizeof(short));
   }
