/*
 *		Sun-2 graphics library.
 *		Ross Finlayson, June 1984.
 */

/* Unary operations on frame buffer rasters. */
/* Exports:	Sun2_BlackenRaster(), Sun2_WhitenRaster(), Sun2_InvertRaster(). */

#include "sun2framebuffer.h"


Sun2_BlackenRaster(dst)
    fb_raster *dst;
    /* Sets the area "dst" to all-ones (i.e. black). */
  {
    register fbAddress xAddr, xEndAddr, yAddr;	/* a5, a4, a3 */
    register fbWord leftMask, rightMask;	/* d7, d6 */
    register screenWidth, height, width, count;	/* d5, d4, d3, d2 */

    unsigned short leftOffset, rightOffset;
    
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    xEndAddr = xAddr + ((width>>3) & ~1);
    rightOffset = width & 15;

    leftMask = 0xFFFF>>leftOffset;		/* e.g. 001111111111111 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Handle the special case of a single 'column' */
    if (width < 16)
      {
        leftMask &= rightMask;
	++leftOffset;
	rightOffset = 0;
      }

    /* Draw the left offset column: */
    --height;
    if (leftOffset > 0)
      {
	count = height;
	yAddr = xAddr;

        asm("clear_leftloop:");			/* do */
	    *(fbWord *)yAddr |= leftMask;
	    yAddr += screenWidth;
        asm("dbf d2,clear_leftloop");		/* while (--count >= 0); */

	xAddr += 2;
      }

    /* Draw the right offset column. */
    if (rightOffset > 0)
      {
	count = height;
	yAddr = xEndAddr;

        asm("clear_rightloop:");		/* do */
	    *(fbWord *)yAddr |= rightMask;
	    yAddr += screenWidth;
        asm("dbf d2,clear_rightloop");		/* while (--count >= 0); */

      }

    /* Draw the midsection, row by row. */
    width = (xEndAddr - xAddr)>>1;
    leftMask = 0xFFFF;
    if (width-- > 0)
      {
	yAddr = xEndAddr;

        asm("clear_midouterloop:");	/* do */
	  {
	    count = width;
	    xAddr = yAddr;

            asm("clear_midinnerloop:");	     /* do */
		asm("movw d7,a5@-");		/* *(xAddr -= 2) = leftMask; */
            asm("dbf d2,clear_midinnerloop");/* while (--count >= 0); */

	    yAddr += screenWidth;
	  }
        asm("dbf d4,clear_midouterloop");/* while (--height >= 0); */

      }
  }


Sun2_WhitenRaster(dst)
    fb_raster *dst;
    /* Sets the area "dst" to all-zeros (i.e. white). */
  {
    register fbAddress xAddr, xEndAddr, yAddr;	/* a5, a4, a3 */
    register fbWord leftMask, rightMask;	/* d7, d6 */
    register screenWidth, height, width, count;	/* d5, d4, d3, d2 */

    unsigned short leftOffset, rightOffset;
    
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    xEndAddr = xAddr + ((width>>3) & ~1);
    rightOffset = width & 15;

    leftMask = 0xFFFF0000>>leftOffset;		/* e.g. 110000000000000 */
    rightMask = 0xFFFF>>rightOffset;		/* e.g. 000011111111111 */

    /* Handle the special case of a single 'column' */
    if (width < 16)
      {
        leftMask |= rightMask;
	++leftOffset;
	rightOffset = 0;
      }

    /* Draw the left offset column: */
    --height;
    if (leftOffset > 0)
      {
	count = height;
	yAddr = xAddr;

        asm("set_leftloop:");			/* do */
	    *(fbWord *)yAddr &= leftMask;
	    yAddr += screenWidth;
        asm("dbf d2,set_leftloop");		/* while (--count >= 0); */

	xAddr += 2;
      }

    /* Draw the right offset column. */
    if (rightOffset > 0)
      {
	count = height;
	yAddr = xEndAddr;

        asm("set_rightloop:");			/* do */
	    *(fbWord *)yAddr &= rightMask;
	    yAddr += screenWidth;
        asm("dbf d2,set_rightloop");		/* while (--count >= 0); */

      }

    /* Draw the midsection, row by row. */
    width = (xEndAddr - xAddr)>>1;
    if (width-- > 0)
      {
	yAddr = xEndAddr;

        asm("set_midouterloop:");		/* do */
	  {
	    count = width;
	    xAddr = yAddr;

            asm("set_midinnerloop:");		/* do */
	    asm("clrw a5@-");			/* *(xAddr -= 2) = 0; */
            asm("dbf d2,set_midinnerloop");	/* while (--count >= 0); */

	    yAddr += screenWidth;
	  }
        asm("dbf d4,set_midouterloop");		/* while (--height >= 0); */

      }
  }


Sun2_InvertRaster(dst)
    fb_raster *dst;
    /* Inverts the pixels in the area "dst". */
  {
    register fbAddress xAddr, xEndAddr, yAddr;	/* a5, a4, a3 */
    register fbWord leftMask, rightMask;	/* d7, d6 */
    register screenWidth, height, width, count;	/* d5, d4, d3, d2 */

    unsigned short leftOffset, rightOffset;
    
    if ( (width = dst->width) <= 0 || (height = dst->height) <= 0 )
        return;

    screenWidth = ScreenLimitX>>3;	/* screen width in bytes */
    /* Compute address of top left corner: */
    xAddr = (fbAddress) GXBase;		/* Frame buffer base address */
    xAddr += mult(dst->y, screenWidth);	/* + rows above the raster */
    xAddr += (dst->x>>3) & ~1;		/* + space to the left */
        
    leftOffset = dst->x & 15; /* (dst->x)%16 */
    width += leftOffset;
    xEndAddr = xAddr + ((width>>3) & ~1);
    rightOffset = width & 15;

    leftMask = 0xFFFF>>leftOffset;		/* e.g. 001111111111111 */
    rightMask = 0xFFFF0000>>rightOffset;	/* e.g. 111100000000000 */

    /* Handle the special case of a single 'column' */
    if (width < 16)
      {
        leftMask &= rightMask;
	++leftOffset;
	rightOffset = 0;
      }

    /* Draw the left offset column: */
    --height;
    if (leftOffset > 0)
      {
	count = height;
	yAddr = xAddr;

        asm("invert_leftloop:");		/* do */
	    *(fbWord *)yAddr ^= leftMask;
	    yAddr += screenWidth;
        asm("dbf d2,invert_leftloop");		/* while (--count >= 0); */

	xAddr += 2;
      }

    /* Draw the right offset column. */
    if (rightOffset > 0)
      {
	count = height;
	yAddr = xEndAddr;

        asm("invert_rightloop:");		/* do */
	    *(fbWord *)yAddr ^= rightMask;
	    yAddr += screenWidth;
        asm("dbf d2,invert_rightloop");		/* while (--count >= 0); */

      }

    /* Draw the midsection, row by row. */
    width = (xEndAddr - xAddr)>>1;
    if (width-- > 0)
      {
	yAddr = xEndAddr;

        asm("invert_midouterloop:");		/* do */
	  {
	    count = width;
	    xAddr = yAddr;

            asm("invert_midinnerloop:");	/* do */
	    asm("notw a5@-");			/* 'invert' *(xAddr -= 2); */
            asm("dbf d2,invert_midinnerloop");	/* while (--count >= 0); */

	    yAddr += screenWidth;
	  }
        asm("dbf d4,invert_midouterloop");	/* while (--height >= 0); */

      }
  }
