/* Given a Rectangle on the Sun-120 screen, generate a VRaster descriptor */
#include <Vfont.h>
extern VRaster Sun120Fb;

VRaster *Sun120Rectangle( raster, rect )
	register VRaster *raster;	/* out: subraster of WholeScreen */
	register Rectangle *rect;	/* in: part of he framebuffer */
  {
    register i;
    i = rect->start.v << 4; i += i << 3;  /* i = rect->start.v * 144 */
    raster[-1].bBox = rect->size;
    raster[-1].xoffset = rect->start.h;
    raster[-1].stride = 144;
    Options(raster[-1]) = 0;
    raster[-1].start = Sun120Fb.start
	+ BitAlign * (rect->start.h >> BitWordLog) + i;
    return( raster );
  }
