/* Given a MemRaster 'in', in NormalOrder orientation, return a subraster
 * (in 'out'), of height 'h' and width 'w', offset by 'dx' and 'dy'.
 * This version currently does no checking of 'where' codes, 'next' links
 * or that the subraster is within 'in'.
 */
#include <bitmaps.h>

MemRaster *
SubRaster2(out, in, dx, dy, h, w)
    register MemRaster *out, *in;
  { int outOffset;
    register i;		/* d7 */
    if (!out) out = (MemRaster*)(malloc(sizeof(MemRaster)));
    out->where = in->where;
    out->width = w;
    out->height = h;
    outOffset = in->bitOffset + dx;
    out->bitOffset = outOffset & 0xF;
    out->stride = in->stride;
    i = in->stride;
#ifndef MC68000
    i *= dy;
#else MC68000
    asm(" muls a6@(22),d7");
#endif MC68000
    out->start = (u_short*)((long)(in->start + (outOffset >> 4)) + i);
    return out;
  }
