#include "sun2framebuffer.h"
#undef mult
#include <m68000.h>
/* macros beginning with 'c' (for "compile"), add instructions to codeTable */
#define cWord(x) {asm(" .word 0x34FC"); asm(x);} /* *code++ = asm(x) */
#define cLong(x)  /* *code++ = x */ \
  {asm(" .word 0x263C"); asm(x); asm(" movl d3,a2@+");}
#define cPaint() { cWord(" orw d6,a5@"); }
#define cIncrementErrorMinor { cWord(" addw d4,d7");}
#define cIncrementErrorMajor { cWord(" addw d5,d7");}
#define cIncrementY { cLong(" lea a5@(144.),a5"); }
#define cDecrementY { cLong(" lea a5@(-144.),a5"); }
#define cIncrementX \
 { cWord(" rorw #1,d6"); cWord(" bpls .+4"); cWord(" addql #2,a5"); }
#define cDecrementX \
 { cWord(" rolw #1,d6"); cWord(" bccs .+4"); cWord(" subql #2,a5"); }
#define cLoopMajor /* assume cc set: dbgt d3,loop */ \
 { *code++ = 0x5ECB; i = (char*)codeTable - (char*)code; *code++ = i; } 
#define cLoopMinor /* if (--count >= 0) goto loop */ \
  { cWord(" subqw #1,d3"); \
    *code++ = 0x6C00; code[-1] |= 0xFF & ((char*)codeTable - (char*)code);}
#define cReturn { cWord(" rts"); }
#define initRow(y) { row = (short*)GXBase; \
    d1 = y; asm(" mulu #144.,d1"); asm(" addl d1,a5"); }
#define initCol(x) { row += (x)>>4; }
#define codeSize 40
#define BRESENHAM Compiling_Sun2_Line
BRESENHAM(x0, y0, dx, dy)
  {
    register short error;		/* d7 */
    register unsigned short mask;	/* d6 */
    register short errorMajor;		/* d5 */
    register short errorMinor;		/* d4 */
    register i;				/* d3 */
#define X 0
#define Y 1
    register short *row;		/* a5 */
    register *a4, *a3;	/* unused */
    register short *code;		/* a2 */
    int majorCoord; /* either X or Y */
    typedef int (*Func)();
    register short codeTable[codeSize];
    int deltaMajor = dx > 0 ? dx : -dx;
    int deltaMinor = dy > 0 ? dy : -dy;
    if (deltaMinor <= deltaMajor)
	majorCoord = X;
    else
      { register int i = deltaMajor;
	deltaMajor = deltaMinor;
	deltaMinor = i;
	majorCoord = Y;
      }
    if (deltaMajor == 0) return;
    errorMajor = 2*deltaMinor;
    errorMinor = -(2*deltaMajor);
    error = -deltaMajor;

    code = codeTable;			/* loop: */
    cPaint();				/* actually plot point */
    if (majorCoord == X)		/* update major coordinate */
       {
	if (dx >= 0) { cIncrementX; }
	else { cDecrementX; }
       }
     else /* majorCoord == Y */
       {
	if (dy >= 0) { cIncrementY; }
	else { cDecrementY; }
       }
    cIncrementErrorMajor;		/* error += 2*deltaMinor */
    cLoopMajor;				/* repeat if e <= 0 && count-- > 0 */
    if (majorCoord == X)		/* update minor coordinate */
	if (dy >= 0) { cIncrementY; }
	else { cDecrementY; }
    else /* majorCoord == Y */
	if (dx >= 0) { cIncrementX; }
	else { cDecrementX; }
    cIncrementErrorMinor;		/* error -= 2*deltaMajor */
    cLoopMinor;				/* if (count >= 0) goto loop */
    cReturn;

    mask = 0x8000 >> (x0 & 15);
    initRow(y0); initCol(x0);
    i = deltaMajor-1;
    (*(Func)codeTable)();
  }
