#include <rasterops.h>
#include <bitmaps.h>
#include <sfont.h>
#include <Vfont.h>
#include <text.h>
#include <m68000.h>
extern VRaster Sun120Fb;
FontEntry *LookupFont();

enum TextRetCode
WriteText2S (str,n,x0,y0,codes,font,bBox)
    unsigned char *str;		/* string to be drawn */
    int n;			/* maximum number of characters to draw */
    int x0,y0;			/* starting position. (0,0) is top left of screen. */
    FontCodes codes;		/* font, function to use and other codes */
    struct fb_raster *bBox;	/* Bounding box */
    register Vfont *font;					   /* a5 */
  { Scaled x = x0 << 16;
    Scaled y = y0 << 16;
    register short i;						   /* d7 */
    register ch;
#if 1
#define dst (&Sun120Fb+1)
#define dstTop bBox->y
#define dstLeft bBox->x
#define dstWidth bBox->width
#define dstHeight bBox->height
#define dstRight (dstLeft+dstWidth)
#define dstBot (dstTop+dstHeight)
#else
#define dstTop 0
#define dstLeft 0
#define dstWidth dst[-1].bBox.h
#define dstHeight dst[-1].bBox.v
#endif
    VRaster rDst, rSrc;
    register VRaster *src;
    int clipTop;    /* twice the number of scan-lines to clip at top */
    short function;

    rDst.stride = dst[-1].stride;
    for (;;)
      { int yTop, xLeft, nRows, nCols, i;
	if (--n < 0) return(TextRetCount);
	function = codes.function;
	ch = *str++;
	src = font->c[ch];
	if (src == 0)
	    if (!execcode()) continue;
	rSrc.stride = src[-1].stride;
	rSrc.start = src[-1].start;
	nRows = src[-1].bBox.v;
	yTop = (y>>16) - src[-1].origin.v;
	if ((i = dstTop - yTop) > 0)
	  { /* clip top by 'i' scanlines */
	    nRows -= i;
	    rSrc.start +=  i * rSrc.stride;
	    yTop = dstTop;
	    /* next lines are just to trick the compiler into not
	     * giving "statement not reached" warnings; ignore them. */
	    asm(" jra _trick_");
	    goto _execcode_; /* Actually don't ... */
	    asm("_trick_:");	    
	  }
	rSrc.xoffset = BitOffset(src);
	nCols = src[-1].bBox.h;
	xLeft = (x>>16) - src[-1].origin.h;
	if ((i = dstLeft - xLeft) > 0)
	  { /* clip left by 'i' pixels */
	    nCols -= i;
	    rSrc.xoffset += i;
	    rSrc.start += (rSrc.xoffset >> BitWordLog) * BitAlign;
	    xLeft = dstLeft;
	  }
	rDst.start = dst[-1].start;
	rDst.start += yTop * rDst.stride;
	rDst.xoffset = xLeft;
	rDst.start += (rDst.xoffset >> BitWordLog) * BitAlign;
	i = dstBot - yTop;
	if (i < nRows)
	    nRows = i;
	i = dstRight - xLeft;
	if (i < nCols)
	    nCols = i;
	rDst.bBox.h = rSrc.bBox.h = nCols;
	rDst.bBox.v = rSrc.bBox.v = nRows;
	if (nCols > 0 && nRows > 0)
	    RasterOpS(&rDst+1, &rSrc+1, function);
	x += src[-1].width.h;
	y += src[-1].width.v;
      }

asm("execcode:")
    /* execcode acts like a subroutine, however no parameters are passed,
     * and all registers are preserved.
     * on return, d0 contains 1 if c should be drawn, 0 if should go to top of loop.
     */
_execcode_: /* to avoid a "statement not reached" warning */
    if (ch > 0x80 && codes.inverseIfHigh)
      { ch &= 0x7F;
	function = (GXcopyInverted & 0x0F) | (GXnoop & 0xF0);
	src = font->c[ch];
      }
    else
     switch (ch)
      {
	case 128: ch = '\0'; src = font->c[0]; break;
        case STOP: return(TextRetStop);
        case FILL: case After1ByteArg:
	    returns(0);
	case SmallHskip:
            if (--n < 0) return(TextRetCount);
            i = (char)(*str++); /* sign extend */
	    /* if (codes.mustClearBackground && i > 0) should clear...*/
            x += i<<16;
            returns(0);
        case QUOTE:
            if (--n < 0) return(TextRetCount);
            ch = *str++;
	    /* ... then fall through to ... */
        default:
            returns(0);
    };
    if (!src) returns(0);
    returns(1);
  }
#if 0
enum TextRetCode
WriteText2(str,n,x,y,codes,bBox)
    unsigned char *str;		/* string to be drawn */
    int n;			/* maximum number of characters to draw */
    int x,y;			/* starting position. (0,0) is top left of screen. */
    FontCodes codes;		/* font, function to use and other codes */
    struct fb_raster *bBox;	/* Bounding box */
  {
    i = codes.fontNum; call(changeFont);
    if (!(fontEntry = LookupFont(codes.fontNum))) goto badFont;
    font = fontEntry->font;
    codes.fontNum = fontEntry->number;
    return WriteText2x(str,n,x,y,codes,bBox)
  badFont:
    printf("!!! Trying to use bad font number: %d !!!\n", i);
    returns(TextRetError);
  }
#endif
