#include "stdio.h"
#include "sfont.h"
#include "bitptr.h"

extern Vfont *AllocFont();

Vfont *
SfontToVfont(vf, sf)
    Vfont *vf; register Sfont *sf;
  { register ch;
    if (vf == NULL) vf = AllocFont();
    { register Vfont *rvf = vf;
    (&rvf->g)[-1].TFMwidth = 0;
    (&rvf->g)[-1].minChar = sf->minChar;
    (&rvf->g)[-1].maxChar = sf->maxChar;
    (&rvf->g)[-1].resolution.h = (&rvf->g)[-1].resolution.v = (80 << 16)/72;
    (&rvf->g)[-1].designSize = 10 << 20;
    for (ch = 0; ch < 256; ch++) rvf->c[ch] = NULL;
    }
    for (ch = sf->minChar; ch <= sf->maxChar; ch++)
      { int cWidth, cWord, cBit;
	  { register CharInfo *cInfo = &sf->widths[ch - sf->minChar];
	    cWidth = cInfo->width;
	    cWord = cInfo->word;
	    cBit = cInfo->bit;
	  }
	if (cWidth != 0)
	  { register CharPrefix *r = (CharPrefix*)AllocRaster(0);
	    int row;
	    u_short *sStart = (u_short*)((char *)sf + cWord);
	    u_char *vStart;
	    r[-1].xoffset = 0; r[-1].stride = ((cWidth + 15) >> 4) << 1;
	    r[-1].bBox.h = cWidth; r[-1].bBox.v = sf->height;
	    r[-1].origin.h = 0; r[-1].origin.v = sf->height - sf->descent;
	    r[-1].width.h = cWidth << 16; r[-1].width.v = 0;
	    r[-1].start = (BitUnit*)calloc(sf->height, r[-1].stride);
	    vStart = (u_char*)r[-1].start;
	    for (row = 0; row < sf->height; ++row )
	      { register u_short *sPtr = sStart;
		register u_short *vPtr = (u_short*)vStart;
		register cols = (cBit + cWidth + 15) >> 4;
		for (;;)
		  { /* NOTE: garbage bits may be set  */
		    *vPtr = *sPtr << cBit;
		    if (--cols <= 0) break;
		    sPtr += sf->height;
		    *vPtr |= *sPtr >> (16 - cBit);
		    vPtr++;
		  }
		sStart++; vStart += r[-1].stride;
	      }
	    vf->c[ch] = r;
	  }
      }
    return vf;
  }
