/*
 * roll.c - RasterRoll SUN graphics primitive
 *
 * Shift up the raster 'w' by 'upby'. (Down if negative.)
 * Useful for scrolling regions in medium sized chunks.
 *
 * Bits shifted out reappear at bottom (top if negative 'upby').
 * GXBASE must be initialized externally.
 * This is hacked up to run fast, and contains assembler code.
 * Written by Per Bothner.	1982-June.
 *
 * Bill Nowicki June 1982
 *	- Updated for NG style
 *	- Fixed pipeline problem
 */

#include <rasterops.h>
#include <framebuf.h>
#include <m68000.h>

extern GXBase;

#define tightLoop(count,body)	\
	{d7=count; go(.+8); body; asm("	dbf	d7,.-2");}

	/*
	 * Equivalent to: for (d7 = count; d7 > 0; d7--) body;
	 * Repeat 'body' d7 times. 
	 * 'body' is c-code which MUST generate 2 bytes of code 
	 * Also depends on the assembler generating a three word
	 * jump instruction.
	 */

RasterRoll(w, upby)
  struct fb_raster *w;
 {
    short *x = w->x + (short*) (GXBase|GXselectX);
    int width;
    register int i;				/* d7 */
      /*
       * The window has two regions (height resp. topheight and botheight) 
       * These are to be swapped. 
       */
    register int topHeight, botHeight;		/* d6, d5 */
    register short *yDest, *ySource, *memp;	/* a5, a4, a3 */
    short *initSource, *initDest;
    short column[512];				/* buffer space for one colmun */

# ifdef debug
printf("Roll:%d. x:%d,y:%d,w:%d,h:%d.\n",upby,w->x,w->y,w->width,w->height);
# endif debug

      /*
       * Set topHeight to upby restricted to range [0..w->height) 
       */
    topHeight = upby; i = w->height;
    rem(d6,d7);
    asm("	extl	d6");
    if (topHeight < 0) topHeight += i;
    botHeight = i - topHeight;
    
    width = w->width;
    GXfunction = GXcopy;
    GXwidth = 16;
    initSource = w->y + (short *) (GXBase|(GXsource|GXselectY));
    initDest = w->y + (short *) (GXBase|(GXupdate|GXselectY));
    if (topHeight < botHeight) 
      {
      		/*
		 * Scroll Up - copy top to memory, bottom to top,
		 * then memory to bottom.
		 */
        while (width > 0) 
	  {
            if (width < 16) GXwidth = width;
	    *x = i;
	    memp = column;
	    ySource = initSource;
	    i = *ySource++;
	    tightLoop(topHeight,*memp++ = *ySource++);
 	    yDest = initDest;
	    ySource--;
	    tightLoop(botHeight,*yDest++ = *ySource++);
	    memp -= topHeight;
	    yDest += GXsource/2;
	    tightLoop(topHeight,*yDest++ = *memp++);
	    x += 16;
	    width -= 16;
          }
      } 
    else 
      {
        initSource += w->height;
	initDest += w->height;
	while (width > 0) 
	  {
            if (width < 16) GXwidth = width;
	    *x = i;
	    memp = column + 512;
	    ySource = initSource;
	    i = *--ySource;
	    tightLoop(botHeight,asm(" movw a4@-,a3@-"));
	    yDest = initDest;
	    ySource++;
	    tightLoop(topHeight,asm(" movw a4@-,a5@-"));
	    memp += botHeight;
	    yDest += GXsource/2;
	    tightLoop(botHeight,asm(" movw a3@-,a5@-"));
	    x += 16;
	    width -= 16;
	  }
      }
}
