/*
 *
 *    This file defines the draw-absolute draw-relative
 * move-absolute and move-relative functions based on the present implementation
 * of vector.c which is a Bresenham line drawing algorithm
 *
 *    Implemented by David J. Brown on March 15th 1982
 *
 * Bill Nowicki July 1982
 *	- Updated for new package names
 */

extern Line(x,y,dx,dy);

static int    Xc,Yc;    /* Current Position, (module globals) */

/*
 * application program interface "functions"
 */
#define drawr(x,y)     {Line(Xc,Yc,x,y); Xc+=x; Yc+=y;}
#define drawa(x,y)     {Line(Xc,Yc,x-Xc,y-Yc); Xc=x; Yc=y;}

#define mover(x,y)    {Xc += x; Yc += y;}
#define movea(x,y)    { Xc = x; Yc = y; }
