/*
 * line.c - Line SUN graphics primitive
 *
 * The Bresenham algorithm for drawing a line.
 *
 * Bill Nowicki June 1982
 * Based on an undocumented hack by Vaughan Pratt
 *
 */

extern int GXBase;

# include "framebuf.h"

# define MOV(reg,sign) (0x3000|reg|sign)  /* builds a movw instruction */
# define RX 0x800			/* a4 holds rx address */
# define RY 0x600			/* a3 holds ry address */
# define POS 0xc0			/* an@+ scans positively */
# define NEG 0x100			/* an@- scans negatively */

static unsigned short mincmd[8] = 
  {
	MOV(RY,POS), MOV(RX,POS),
	MOV(RY,POS), MOV(RX,NEG),
	MOV(RY,NEG), MOV(RX,POS),
	MOV(RY,NEG), MOV(RX,NEG)
  };

static unsigned short majcmd[8] = 
  {
	MOV(RX,POS), MOV(RY,POS),
	MOV(RX,NEG), MOV(RY,POS),
	MOV(RX,POS), MOV(RY,NEG),
	MOV(RX,NEG), MOV(RY,NEG)
  };

  /*
   * On initialization we copy the assembly language routine
   * from text space to this array in data space, because we will plug it.
   * The constants indicate how long it is, and the indices to plug.
   */

# define BRESIZE	10	/* size of assembler module in shorts */
# define BRESMINOR	0	/* minor command index */
# define BRESMAJOR	1	/* major command index */

extern short bres[];
static short BresWork[BRESIZE];


static Initialized = 0;		/* true if initialized */

Line(x0,y0,x,y)
    unsigned x0,y0;
    register x, y; 			/* d7, d6 */
  {
    register q = 0, r;			/* d5, d4 */
    register unsigned t = 0;		/* d3 */
    register short *bresw = BresWork;	/* a5 */
    register unsigned short *rx, *ry;	/* a4, a3 */

	/*
	 * The routine does not do any clipping, so we must test that
	 * all  coordinates are in [0,1024) 
	 */
    if ( (x0|y0|(x0+x)|(y0+y)) >> 10 ) return -1;

    if (Initialized==0)
      {
         for (t=0; t<BRESIZE; t++) 
	     bresw[t] = bres[t];
	 Initialized++;
      }

    rx = (unsigned short*)(GXBase|GXsource|GXselectx) + x0;
    ry = (unsigned short*)(GXBase|GXsource|GXselecty) + y0;

    if (x<0) 
      {
        x = -x;
        rx++;		/* since an@- predecrements */
        q += 2;
      }

    if (y<0) 
      {
        y = -y;
        ry++;		/* since an@- predecrements */
        q += 4;
      }

    if (x<y) 
      {
        t = x;
        x = y;
        y = t;
        q += 1;
        ry = (unsigned short *)( (int)ry | GXupdate);
      }
    else
        rx = (unsigned short *)( (int)rx | GXupdate);

    bresw[BRESMINOR] = mincmd[q];
    bresw[BRESMAJOR] = majcmd[q];
    q = x;
    r = -(x>>1);
	/*
	 * Here we actually call the routine we have selected
	 */
    (*(int (*)())(&bresw[0]))();	
    return 0;
}
