/*
 * copy.c - RasterCopy SUN graphics primitive
 *
 *  Translate (and/or copy) rasters in the framebuffer
 *
 *    Presently this routine has the limitation that no clipping is done for
 * rasters which extend beyond the physical boundaries of the framebuffer when 
 * moved.
 *
 *    Implemented by David J. Brown on 7 July, 1981
 *
 * Bill Nowicki May 1982
 * 	- Removed debug definition which was never used anyway
 *	- Removed extra TOUCHes of X coordinate in case 3
 *	- Changed TOUCH to use a register instead of zero (read modify write problem)
 *	- Updated to NG style
 *	- Removed PreFetching for Rev C. Frame buffer.
 *	- Corrected incrementing & decrementing to allow for above
 *	- Used PreDecrement indexing mode
 */

#include <rasterops.h>
#include <framebuf.h>

RasterCopy(dst, src)
    struct fb_raster    *dst, *src;
{
    register short			/* a5, a4, a3, a2 */

	*Y_Dst_Address = 
            (short *)(GXBase|GXupdate|GXset3|GXselectY+((dst->y)<<1)),
	*X_Dst_Address =
	    (short *)(GXBase|GXset3|GXselectX+((dst->x)<<1)),
	*Y_Src_Address =
	    (short *)(GXBase|GXsource|GXset0|GXselectY+((src->y)<<1)),
	*X_Src_Address =
	    (short *)(GXBase|GXset0|GXselectX+((src->x)<<1));

    register short	i,j;			/* d7, d6 */
    register short	h = src->height,	/* d5, d4 */
                        w = src->width;

    if (dst->x > src->x)
      {
            /*
	     * if so, Outer loop is a decrement loop, so add the initial 
	     * width to begin from the right.
	     */
	X_Dst_Address += w & 0xfff0;
	X_Src_Address += w & 0xfff0;
	
    /*======================================================================
     * Case 0: (Dst->X > Src->X) AND (Dst->Y > Src->Y)
     *         Outer loop is an decrement loop, Inner loop is decrement
     *
     * (When the outer loop is decrementing (as in cases 0 and 1), do the
     *  special iteration of the inner loop (for leftover width) first)
     *=====================================================================
     */
	if (dst->y > src->y)
	  { 	
            /*
	     * Special iteration of inner loop performed if width is not
	     * an even multiple of sixteen bits -- have to do this since
	     * we must change the setting of the Width register. It's
	     * done AT MOST once per "copy" operation however.
	     */
	    if (w & 0xf)
	      {
                GXwidth = w & 0xf;
		Y_Dst_Address += h; /* 0 to h-1 constitutes h columns	*/
                Y_Src_Address += h;
                *X_Src_Address = i;  /* access sets the address 	*/
		*X_Dst_Address = i;  /*   "     "    "     "	*/
                for (j=h ; j>0 ; j--)
		  {
	            /*   *--Y_Dst_Address = *--Y_Src_Address;   */
		    asm( "movw a3@-,a5@-" );
                  }
	      }
            GXwidth = 16;
            for (i=w>>4 ; i>0 ; i--)
	      {
	        X_Dst_Address -= 16;
                X_Src_Address -= 16;
                Y_Dst_Address += h;
                Y_Src_Address += h;
                *X_Src_Address = i;
		*X_Dst_Address = i;
                for(j=h ; j>0 ; j--)
		  {
	            /*   *--Y_Dst_Address = *--Y_Src_Address;   */
		    asm( "movw a3@-,a5@-" );
	          }
	    }
        }    /* end of case: "inner-loop is decrement" */


    /*======================================================================
     * Case 1: (Dst.x > Src.x) AND (Dst->Y <= Src->Y)
     *         Outer loop is a decrement loop, Inner loop is increment
     *=====================================================================
     */
        else
	  {
	       /*
	        * (dst->y <= src->y) thus inner loop is an increment loop 
		*/
	    if (w & 0xf)
	      {
                GXwidth = w & 0xf;
                *X_Src_Address = i;
		*X_Dst_Address = i;
                for (j=h ; j>0 ; j--)
		  {
                    *Y_Dst_Address++ =  *Y_Src_Address++;
                  }
                Y_Src_Address -= h;
                Y_Dst_Address -= h;
	      }
	
            GXwidth = 16;
            for(i=w>>4 ; i>0 ; i--)
	      {
	        X_Dst_Address -= 16;
                X_Src_Address -= 16;
                *X_Src_Address = i;
		*X_Dst_Address = i;
	    
                for (j=h ; j>0 ; j--)
		  {
		    *Y_Dst_Address++ =  *Y_Src_Address++;
	          }
                
                Y_Dst_Address -= h;     /* adjust for h increments */
                Y_Src_Address -= h; 	/* adjust for h increments */

	    }
        }	
    }

    /*======================================================================
     * Case 2: (Dst->X <= Src->X) AND (Dst->Y > Src->Y)
     *         Outer loop is an increment loop, Inner loop is decrement
     *
     *=====================================================================
     */

    else
      {
 	 /*
	  * (src->x <= dst->x) thus Outer loop will be an increment loop 
	  */
        if (dst->y > src->y)
	  {
            GXwidth = 16;
            for (i= w>>4 ; i>0 ; i--)
	      {
                Y_Src_Address += h;
                Y_Dst_Address += h;
                *X_Src_Address = i;
		*X_Dst_Address = i;    /* load the dst-x-address */
	        for (j=h ; j>0 ; j--)
		  {
	            /*   *--Y_Dst_Address = *--Y_Src_Address;   */
		    asm( "movw a3@-,a5@-" );
	          }
	        X_Dst_Address += 16;    /* update X address to next column */
	        X_Src_Address += 16;
            }

            /* if there's any leftover width perform one special iteration */
            if (w &= 0xF)
	      {
	        GXwidth = w;		/* set a narrower width */
                Y_Src_Address += h;
                Y_Dst_Address += h;
                *X_Src_Address = i;
                *X_Dst_Address = i;
	        for (j=h ; j>0 ; j--)
		  {
	            /*   *--Y_Dst_Address = *--Y_Src_Address;   */
		    asm( "movw a3@-,a5@-" );
	          }
	    }
        }
    

    /*======================================================================
     * Case 3: (Dst->X <= Src->X) AND (Dst->Y <= Src->Y)
     *         Outer loop is an increment loop, Inner loop is increment
     *=====================================================================*/

        else
	  {
            GXwidth = 16;
            for (i= w>>4 ; i>0 ; i--)
	      {
	        *X_Dst_Address = i;
                *X_Src_Address = i;
                j = h;
		switch (j&3)
		  {
		    case 3:
		    	j--;
                 	*Y_Dst_Address++ = *Y_Src_Address++;
		      
		    case 2:
		    	j--;
                 	*Y_Dst_Address++ = *Y_Src_Address++;

		    case 1:
		    	j--;
                 	*Y_Dst_Address++ = *Y_Src_Address++;
		  }
	        for (; j>0 ; j -= 4)
		  {
                    *Y_Dst_Address++ = *Y_Src_Address++;
                    *Y_Dst_Address++ = *Y_Src_Address++;
                    *Y_Dst_Address++ = *Y_Src_Address++;
                    *Y_Dst_Address++ = *Y_Src_Address++;
	          }
                Y_Dst_Address -= h;
                Y_Src_Address -= h;
	        X_Dst_Address += 16;    /* update X address to next column */
	        X_Src_Address += 16;
            }

            /* if there's any leftover width perform one special iteration */
            if (w &= 0xF)
	      {
	        GXwidth = w;		    /* set the lefover width */
                *X_Src_Address = i;
		*X_Dst_Address = i;
	        for (j=h ; j>0 ; j--)
		  {
	            *Y_Dst_Address++ = *Y_Src_Address++;
	          }
	    }
        }
    }
}
