/*
 * vectime.c - time some vector algorithms
 *
 * Bill Nowicki June 1982
 * Based on some undocumented hacks by Vaughan Pratt
 */

unsigned short fudge = 32;
unsigned fudge2 = 64;

#include "framebuf.h"

int GXBase;

#define MOV(reg,sign) (0x3000|reg|sign)  /* builds a movw instruction */
#define RX 0xa00	/* a5 holds x address */
#define RY 0x800	/* a4 holds y address */
#define POS 0xc0	/* an@+ scans positively */
#define NEG 0x100	/* an@- scans negatively */

unsigned short buf[8192], *rtsbuf[30], **rtsp;

unsigned short mincmd[8] = {
	MOV(RY,POS), MOV(RX,POS),
	MOV(RY,POS), MOV(RX,NEG),
	MOV(RY,NEG), MOV(RX,POS),
	MOV(RY,NEG), MOV(RX,NEG)
};

unsigned short majcmd[8] = {
	MOV(RX,POS), MOV(RY,POS),
	MOV(RX,NEG), MOV(RY,POS),
	MOV(RX,POS), MOV(RY,NEG),
	MOV(RX,NEG), MOV(RY,NEG)
};

unsigned short *free, *copy(), *expt(), *blt();

# define RADIUS 350
# define AGON 36	/* Number of sides in the plygon we are drawing */
# define TIMES 10	/* number of times to draw pattern */
# define XCENT 400	/* Center of pattern */
# define YCENT 400

DoVRP()
  {
	int cos, sin, cx[AGON], cy[AGON], x, y, i, j, start = K_ticks();

	putchar('\n');
	cx[0] = RADIUS;
	cy[0] = 0;
	cos = 32270;	/* cos 10 degrees * 32768 */
	sin = 5690;	/* sin 10 degrees * 32768 */
	for (i = 1; i < AGON; i++) 
	  {
		x = cx[i-1]*cos - cy[i-1]*sin + 16384;
		y = cx[i-1]*sin + cy[i-1]*cos + 16384;
		cx[i] = x>>15;
		cy[i] = y>>15;
	  }
	for (i = 0; i < AGON; i++) 
	  {
		cx[i] = cx[i] + XCENT;
		cy[i] = cy[i] + YCENT;
	  }
	ScreenSet();
	for (x = 0; x < TIMES; x++)
	 {
	  for (i = 0; i < AGON; i++)
		for (j = i+1; j < AGON; j++) 
		  {
			GXfunction = GXinvert;
			GXwidth = 1;
			VRPvec(cx[i],cy[i],cx[j],cy[j]);
		  }
	}
  printf( "Pratt's method took %d milliseconds\n", K_ticks() - start );
}

VRPvec(x0,y0,x1,y1)
unsigned x0,y0,x1,y1;
{

	register x, y;
	register unsigned q = 0, r = 0, t = 0;
	register unsigned short *rx, *ry;
	unsigned short *X, *Y;

	if ( (x0|y0|x1|y1) >> 10 ) return -1;	/* test coords in [0,1024) */

	GXwidth = 1;

	rx = (unsigned short*)(GXBase|GXsource|GXselectx) + x0;
	ry = (unsigned short*)(GXBase|GXsource|GXselecty) + y0;

	x = x1 - x0;				/* x,y relative to x0,y0 */
	y = y1 - y0;

	if (x<0) {
		x = -x;
		rx++;		/* since an@- predecrements */
		q += 2;
	}

	if (y<0) {
		y = -y;
		ry++;		/* since an@- predecrements */
		q += 4;
	}

	if (x<y) {
		t = x;
		x = y;
		y = t;
		q += 1;
		ry = (unsigned short *)( (int)ry | GXupdate);
	}
	else
		rx = (unsigned short *)( (int)rx | GXupdate);

	buf[0] = 1;
	buf[1] = mincmd[q];
	buf[2] = 1;
	buf[3] = majcmd[q];

	free = &buf[4];
	X = &buf[2]; 
	Y = &buf[0];

	rtsp = rtsbuf;

	while (y) {
		asm("	movl	d7,d0");	/* move x to d0 */
		asm("	divu	d6,d0");	/* form x/y, x%y */
		asm("	movw	d0,d5");	/* q = x/y */
		asm("	swap	d0");		/* swap x%y, x/y */
		asm("	movw	d0,d4");	/* r = x%y */
		t = (int)X;
		X = copy(Y,X,q);
		Y = (unsigned short *)t;
		x = y;
		y = r;
	}
	if (x > 1) {
		free++;
		X = expt(X,x,0) - 1;
	}
	buf[2] = 0x4e71;			/* noop */
	buf[4] = free[0] = 0x4e75;		/* some rts's */
	*rtsp = 0;				/* delimit rtsbuf */
	rtsp = rtsbuf;				/* go back to rtsbuf start */
	while (*rtsp) *(*rtsp++) = 0x4e75;	/* put in rest of rts's */
	(*(int (*)())&buf[1])();		/* execute minor/major */
	(*(int (*)())&X[1])();			/* execute vector program */
	return 0;
}

unsigned short *
copy(a,b,n)
    register unsigned short *a;
    unsigned short *b;
    register n;
  {

	register unsigned short *f, *start, *b8 = 0;
	if (n > fudge2) {
		free++;				/* make space for prev. rts */
		b8 = free;
		expt(b,8,0);			/* form b**8 */
		*free++ = 0x4e75;		/* followed by rts */
	}
	start = free++;
	expt(b,n>>1,b8);
	if (a[0] == 1) *free++ = a[1];
	else free = blt(*a,a+1,free);
	expt(b,(n+1)>>1,b8);
	*start = ( ( (int)free - (int)start ) >> 1 ) - 1;
	return start;
}

unsigned short *
blt(n,from,to)
register unsigned short *from, *to;
{

	switch (n) {
	case 64:	*to++ = *from++;
	case 63:	*to++ = *from++;
	case 62:	*to++ = *from++;
	case 61:	*to++ = *from++;
	case 60:	*to++ = *from++;
	case 59:	*to++ = *from++;
	case 58:	*to++ = *from++;
	case 57:	*to++ = *from++;
	case 56:	*to++ = *from++;
	case 55:	*to++ = *from++;
	case 54:	*to++ = *from++;
	case 53:	*to++ = *from++;
	case 52:	*to++ = *from++;
	case 51:	*to++ = *from++;
	case 50:	*to++ = *from++;
	case 49:	*to++ = *from++;
	case 48:	*to++ = *from++;
	case 47:	*to++ = *from++;
	case 46:	*to++ = *from++;
	case 45:	*to++ = *from++;
	case 44:	*to++ = *from++;
	case 43:	*to++ = *from++;
	case 42:	*to++ = *from++;
	case 41:	*to++ = *from++;
	case 40:	*to++ = *from++;
	case 39:	*to++ = *from++;
	case 38:	*to++ = *from++;
	case 37:	*to++ = *from++;
	case 36:	*to++ = *from++;
	case 35:	*to++ = *from++;
	case 34:	*to++ = *from++;
	case 33:	*to++ = *from++;
	case 32:	*to++ = *from++;
	case 31:	*to++ = *from++;
	case 30:	*to++ = *from++;
	case 29:	*to++ = *from++;
	case 28:	*to++ = *from++;
	case 27:	*to++ = *from++;
	case 26:	*to++ = *from++;
	case 25:	*to++ = *from++;
	case 24:	*to++ = *from++;
	case 23:	*to++ = *from++;
	case 22:	*to++ = *from++;
	case 21:	*to++ = *from++;
	case 20:	*to++ = *from++;
	case 19:	*to++ = *from++;
	case 18:	*to++ = *from++;
	case 17:	*to++ = *from++;
	case 16:	*to++ = *from++;
	case 15:	*to++ = *from++;
	case 14:	*to++ = *from++;
	case 13:	*to++ = *from++;
	case 12:	*to++ = *from++;
	case 11:	*to++ = *from++;
	case 10:	*to++ = *from++;
	case 9:		*to++ = *from++;
	case 8: 	*to++ = *from++;
	case 7:		*to++ = *from++;
	case 6:		*to++ = *from++;
	case 5:		*to++ = *from++;
	case 4:		*to++ = *from++;
	case 3:		*to++ = *from++;
	case 2:		*to++ = *from++;
	case 1:		*to++ = *from++;
	}
	return to;
}

unsigned short *
expt(b,n,b8)
unsigned short *b, *b8;
register n;
{

	register unsigned short *f, *bb, *start;
	register i;
	start = f = free;

	if (b8) {
		*f++ = 0x2f08;			/* movl a0,a7@- */
		*f++ = 0x207c;			/* movl #x,a0 */
		*f++ = (short)((int)b8 >> 16);	/* where x = b */
		*f++ = (short)b8;
		i = 8;
		while (i--) *f++ = 0x4e90;	/* jsr a0@ */
		*f++ = 0x205f;			/* movl a7@+,a0 */
		n &= 7;				/* n = n%8 */
	}

	if (b[0] > fudge || (b[0] >= 6 && n >= 6)) {
		*rtsp++ = b+b[0]+1;		/* a place to insert rts */
		b++;
		*f++ = 0x2f08;			/* movl a0,a7@- */
		*f++ = 0x207c;			/* movl #x,a0 */
		*f++ = (short)((int)b >> 16);	/* where x = b */
		*f++ = (short)b;
		while (n--) *f++ = 0x4e90;	/* n calls to b */
		*f++ = 0x205f;			/* movl a7@+,a0 */
	}

	else while (n--) {
		if (b[0] == 1) *f++ = b[1];
		else f = blt(b[0],b+1,f);
	}

	free = f;
	return start;
}

extern short major, minor, minor0;

DoDJB()
  {
	int cos, sin, cx[AGON], cy[AGON], x, y, i, j, start = K_ticks();

	putchar('\n');
	cx[0] = RADIUS;
	cy[0] = 0;
	cos = 32270;	/* cos 10 degrees * 32768 */
	sin = 5690;	/* sin 10 degrees * 32768 */
	for (i = 1; i < AGON; i++) {
		x = cx[i-1]*cos - cy[i-1]*sin + 16384;
		y = cx[i-1]*sin + cy[i-1]*cos + 16384;
		cx[i] = x>>15;
		cy[i] = y>>15;
	}
	for (i = 0; i < AGON; i++) {
		cx[i] = cx[i] + XCENT;
		cy[i] = cy[i] + YCENT;
	}
	ScreenSet();
	for (x = 0; x < TIMES; x++)
	 {
  	  for (i = 0; i < AGON; i++)
		for (j = i+1; j < AGON; j++) 
		  {
			GXfunction = GXinvert;
			GXwidth = 1;
			LineDJB( cx[i], cy[i], cx[j]-cx[i], cy[j]-cy[i]);
		  }
	 }
  printf( "DJB's Bresenham took %d milliseconds\n", K_ticks() - start );
}

DoBres()
  {
	int cos, sin, cx[AGON], cy[AGON], x, y, i, j, start = K_ticks();

	putchar('\n');
	cx[0] = RADIUS;
	cy[0] = 0;
	cos = 32270;	/* cos 10 degrees * 32768 */
	sin = 5690;	/* sin 10 degrees * 32768 */
	for (i = 1; i < AGON; i++) {
		x = cx[i-1]*cos - cy[i-1]*sin + 16384;
		y = cx[i-1]*sin + cy[i-1]*cos + 16384;
		cx[i] = x>>15;
		cy[i] = y>>15;
	}
	for (i = 0; i < AGON; i++) {
		cx[i] = cx[i] + XCENT;
		cy[i] = cy[i] + YCENT;
	}
	ScreenSet();
	for (x = 0; x < TIMES; x++)
	 {
  	  for (i = 0; i < AGON; i++)
		for (j = i+1; j < AGON; j++) 
		  {
		  	GXwidth = 1;
			GXfunction = GXinvert;
			Line( cx[i], cy[i], (cx[j]-cx[i]), (cy[j]-cy[i]) );
		  }
	 }
  printf( "Bresenham took %d milliseconds\n", K_ticks() - start );
}



main()
  {
	GXBase = GXProbe();
	printf("Vector timer program\n");
	while (1)
	  {
	    register char c;
	     printf( "Enter v for VRP's method, or b for VRP's Bresenham, d for DJB's:");
	     switch (c = getchar())
	       {
	         case 'v': DoVRP(); 	break;
		 case 'b': DoBres();	break;
		 case 'd': DoDJB();	break;
		 case 'q': putchar('\n'); exit();
		 case 'r': while (K_mayget()==-1) DoBres();
		 	   		break;
		 default:  printf("You typed 0%o, %c\n", c, c);
	       }
	      printf("\nEnter q to quit\n");
	  }
  }
