/* Generates a compact 256*16*8 pixel array representation of a font.
 * There may be one or two input "gf" fonts.
 * Usage: see the end of the program for documentation.
 * Per Bothner. November 1985.
 */
#include <stdio.h>
#include <Vfont.h>

extern u_char BitReverse[];
extern Vfont *LoadGenericFont();
int Put16 = 0; /* if 1: output is in left-adjusted short words, if 0: chars */
int BitRev = 0;

static Vfont *
GetFont(name)
    char *name;
  { SystemCode error;
    Vfont *fnt = LoadGenericFont(0, name, 0, &error);
    if (error == OK) return fnt;
    fprintf(stderr, "Cannot load font - %s\n", ErrorString(error));
    exit(-1);
  }

main(argc, argv)
    int argc; char **argv;
  {
    register i;
    int ch;
    Vfont *fontStd, *fontTop;
    char *StdFontName;
    int StdMask=0; /* 0xFF == Inverse video first 128 chars */
    int TopMask; /* 0xFF == Inverse video last 128 chars */

    if (argc < 2 || argc > 5)
	goto printUsage;
    for (;;)
      {
	if (strcmp(argv[1], "-16") == 0 || strcmp(argv[1], "16") == 0)
	  {
	    Put16 = 1;
	    argc--;
	    argv++;
	  }
	else if (strcmp(argv[1], "-r") == 0)
	  {
	    BitRev = 1;
	    argc--;
	    argv++;
	  }
	else break;
      }
    StdFontName = argv[1];
    if (StdFontName[0] == '+') { StdMask = 0xFF; StdFontName++; }
    TopMask = ~StdMask;
    fontStd = GetFont(StdFontName);
    if (argc == 3)
      {
	char *TopFontName = argv[2];
	if (TopFontName[0] == '+') { TopMask = -1; TopFontName++; }
	if (TopFontName[0] == '\0')
	    argc == 2;
	else
	  {
	    fontTop = GetFont(TopFontName);
	    printf("/* Generated from %s+%s using the genstdfont program */\n",
		StdFontName, TopFontName);
	  }
      }
    if (argc == 2)
      {
	fontTop = fontStd;
	printf("/* Generated from %s using the genstdfont program */\n",
	    StdFontName);
      }
    if (Put16 == 0)
	printf("unsigned char StandardFont[256*16] = {\n");
    else
	printf("unsigned short WideStandardFont[256*16] = {\n");
    for (ch = 0; ch < 256; ch++)
      {
	register VRaster *r;
	register BitUnit *p;
	int xormask;
	if (ch < 128)
	  {
	    r = fontStd->c[ch];
	    xormask = StdMask;
	  }
	else
	  {
	    r = fontTop->c[ch-128];
	    xormask = TopMask;
	  }
	xormask &= 0xFF;
	if (Put16 != 0)
	    xormask <<= 8;
	if (r == NULL)
	    i = 16;
	else
	  {
	    i = 12 - r[-1].origin.v;
	    if (i < 0)
	      { fprintf(stderr, "Char 0%o is too high!\n", ch); exit(-1); }
	    while (--i >= 0) printf("%d,", xormask);
	    for (i = r[-1].bBox.v, p = r[-1].start; --i >= 0; p += r[-1].stride)
	      {
		register w = (*(unsigned*)p >> (24 - r[-1].origin.h)) & 0xFF;
		if (BitRev == 1)
		    w = BitReverse[w];
		if (Put16 != 0)
		    w <<= 8;
		w = w^xormask;
		printf("0x%x,", w);
	      }
	    i = 4 + r[-1].origin.v - r[-1].bBox.v;
	    if (i < 0)
	      { fprintf(stderr, "Char 0%o is too tall!\n", ch); exit(-1); }
	  }
	while (--i >= 0) printf("%d,", xormask);
	printf("\n");
      }
    printf("};\n");
    return;

  printUsage:
fputs(
"Output (on stdout) is a 256*16*8 bit font in the form of a C program.\n\
Usage: genstdfont [-16] [-r] [+]lowfont [+][hifont]\n\
This program declares and initializes 'unsigned char StandardFont[256*16]'\n\
If the '-16' is given, the result is unsigned short WideStandardFont.\n\
If '-r' is given, the bits are reversed (different endian-ness).\n\
lowfont and hifont are names of gf font files.\n\
A '+' indicates that black pixels should be zero instead of one.\n\
hifont defaults to lofont, but with opposite '+' flag\n\
Recommended for sun: genstdfont [sys]fonts/ascii12.gf\n\
Recommended for mvax: genstdfont -r +[sys]fonts/ascii12.gf\n", stderr);
  }
