#include "stdio.h"
#include "bitptr.h"
#include "Vfont.h"
#include "gfont.h"
#define NEW_GF 1

static gf_paint(d, f) /* generate appropriately-size gf paint command */
    FILE *f;
  {
    if (d < 64) {putc(paint_0 + d, f);}
    else if (d < 256) {putc(paint1, f); putc(d, f);}
    else { putc(paint2, f); PutUnsigned2(d, f);}
  }

#if 0
static gf_new_row(d, f)
    FILE *f;
  {
    if (d >= -82 && d <= 82) {putc(right_z_0 + d, f);}
    else { putc(newrow, f); PutSigned4(d, f);}
  }
#endif

WriteGfFont(font, f)
    FILE *f;
    Vfont *font;
  { int i, ch; char *p;
    register CharPrefix *r;
#define INF 0x7FFF
    int minX = INF, maxX = -INF, minY = INF, maxY = -INF;
    long post_addr; /* address of post-amble */
    int outPos[256];

    /* write out preamble */
    fputc(pre, f);
    fputc(gf_magic, f);
#if 0
    for (p = curFontName; *p != '\0' && *p != '.'; p++) { }
    i = p - curFontName; if (i > 127) i = 127;
    fputc(i, f);
    fwrite(curFontName, i, 1, f);
#else
    fputc(0, f);
#endif

    /* write out each character in the font */
    for (ch = 0; ch <= 255; ch ++)
	if ((r = font->c[ch]) == 0)
	    outPos[ch] = -1;
	else
	  { int dx, dy, h, w;

	    outPos[ch] = ftell(f);

	    if (BoundingBox(r, &dx, &dy, &h, &w))
	      { struct BitPtr bitPtr;
		int color;
		int
		    c_minX = dx - r[-1].origin.h,
		    c_maxX = w + c_minX,
		    c_maxY = r[-1].origin.v - dy - 1,
		    c_minY = c_maxY - h + 1;

		if ((unsigned)c_maxY < 256 && (unsigned)c_maxX < 256
		  && (unsigned)(c_maxX - c_minX) < 256
		  && (unsigned)(c_maxY - c_minY) < 256)
		  {
		    fputc(boc1, f);
		    fputc(ch, f);
		    fputc(c_maxX - c_minX, f);
		    fputc(c_maxX, f);
		    fputc(c_maxY - c_minY, f);
		    fputc(c_maxY, f);
		  }
		else
		  {
		    putc(boc, f);
		    PutSigned4((unsigned char) ch, f);
		    PutSigned4(-1, f);	/* no backpointer */
		    PutSigned4(c_minX, f);
		    PutSigned4(c_maxX, f);
		    PutSigned4(c_minY, f);
		    PutSigned4(c_maxY, f);
		  }

		if (c_minX < minX) minX = c_minX;
		if (c_maxX > maxX) maxX = c_maxX;
		if (c_minY < minY) minY = c_minY;
		if (c_maxY > maxY) maxY = c_maxY;
		    
		SetBitPtr(&bitPtr, r, dx, dy);
		for (color = SearchWhite; ; )
		  { int x0 = bitPtr.x, y0 = bitPtr.y, delta_y, delta_x;
		    color = !color; /* next color */
		    if (SearchBit(&bitPtr, color|SearchEdge) == 1)
			gf_paint(bitPtr.x - x0, f);
		    else
		      {
			if (color == SearchWhite)
			    gf_paint(bitPtr.x - x0, f);
			if (SearchBit(&bitPtr, SearchBlack|SearchDown) != 1)
			    break;
			delta_x = bitPtr.x - r[-1].origin.h - c_minX;
			delta_y = bitPtr.y - y0 - 1;
			if (delta_y == 0 && delta_x <= 165)
			  { fputc(new_row_0 + delta_x, f); }
			else
			  {
			    if (delta_y >= 256)
			      { fputc(skip2, f); PutUnsigned2(delta_y, f); }
			    else if (delta_y > 0)
			      { fputc(skip1, f); fputc(delta_y, f);}
			    else { fputc(skip0, f);}
			    gf_paint(delta_x, f);
			  }
			color = SearchBlack;
		      }
		  }
	      }
	    else
	      {		/* empty character */
		putc (boc1, f);
		putc ((unsigned char) ch, f);
		for (i = 4; --i >= 0;)
		    putc (0, f);
	      }

	    putc(eoc, f);
	  }

    /* write out postamble */
    post_addr = ftell(f);
    fputc(post, f);
    PutSigned4(post_addr, f);
    PutSigned4((&font->g)[-1].designSize, f);
    PutSigned4(0, f);	/* checksum */
    PutSigned4((&font->g)[-1].resolution.h, f);
    PutSigned4((&font->g)[-1].resolution.v, f);
    PutSigned4(minX, f);
    PutSigned4(maxX, f);
    PutSigned4(minY, f);
    PutSigned4(maxY, f);
    for (ch = 0; ch <= 255; ch ++)
	if ((r = font->c[ch]) != 0)
	  { int wide;
	    wide = r[-1].width.v != 0 || (r[-1].width.h & 0xFF00FFFF) != 0;
	    putc (wide ? char_loc : char_loc0, f);
	    putc(ch, f);
	    if (wide)
	      {
		PutSigned4 (r[-1].width.h, f);
		PutSigned4 (-r[-1].width.v, f);
	      }
	    else
		fputc(r[-1].width.h >> 16, f);
	    if ((&font->g)[-1].TFMwidth != 0)
		PutSigned4((&font->g)[-1].TFMwidth[ch], f);
	    else
		PutSigned4(0, f);
	    PutSigned4(outPos[ch], f);
	  }
    fputc(postpost, f);
    PutSigned4(post_addr, f);
    fputc(gf_magic, f);
    for (i = 7 - ((ftell(f) + 3) & 3); --i >= 0; ) putc(postfill, f);
  }
