#include "bitptr.h"
struct BitPtr BitPtr;

/* SetBitPtr(p, r, x, y)
 * Set p to point to the y'th row and x'th column of r.
 * r->origin[*] is ignored.
 */

SetBitPtr(p, r, x, y)
    register struct BitPtr *p;
    register CharPrefix *r;
  { register bit = x + BitOffset(r);
    p->x = x;
    p->y = y;
    p->r = r;
    p->mask = LeftZeros(bit & (BitWordLen-1));
    p->ptr = (BitWord*)r[-1].start + (bit >> BitWordLog);
    if (y != 0) p->ptr = (BitWord*)((BitUnit*)p->ptr + y * r[-1].stride);
  }
