/* Print out a VRaster as a character array: '*' for 1-pixels, etc */
#include <stdio.h>
#include <Vfont.h>
#define BitUnitFirstOne (1 << (BitUnitLen-1)) /* 1 in leftmost bit only */
VRaster *
RasterPrint(r, f)
    register VRaster *r;
    FILE *f;
  {
    register h = r[-1].bBox.v, w = r[-1].bBox.h;
    BitUnit *rowStart = r[-1].start + (BitOffset(r) >> BitUnitLog);
    int startMask = BitUnitFirstOne >> (r[-1].xoffset & (BitUnitLen - 1));
    int baseLine = h - r[-1].origin.v;
    while (--h >= 0)
      {
	register BitUnit *word = rowStart;
	register mask = startMask;
	register int x;
	for (x = w; --x >= 0; )
	  {
	    if (*word & mask) fputc('*', f);
	    else if (h == baseLine) fputc('_', f);
	    else fputc('.', f);
	    if (mask == 1) { word++; mask = BitUnitFirstOne; }
	    else mask >>= 1;
	  }
	fputc('\n', f);
	rowStart = rowStart + r[-1].stride;
      }
    return r;
  }
